/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.seasar.kijimuna.core.dicon.DiconNature;
import org.seasar.kijimuna.core.dicon.ModelManager;
import org.seasar.kijimuna.core.dicon.model.ArgElement;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.dicon.model.DiconElement;
import org.seasar.kijimuna.core.dicon.model.MethodElement;
import org.seasar.kijimuna.core.dicon.model.PropertyElement;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class ModelUtils {

    
	public static String getMethodDisplay(IRttiMethod method, boolean fullDisplay) {
	    return getMethodDisplay(method.getParent(),
	            method.getMethodName(), method.getArgs(), fullDisplay);
	}
	
	public static String getMethodDisplay(
		        IRtti component, String methodName, IRtti[] args, boolean fullDisplay) {
		StringBuffer buffer = new StringBuffer();
		if(fullDisplay) {
		    buffer.append(component.getQualifiedName()).append("#");
		}
		buffer.append(methodName).append("(");
        for(int i = 0; i < args.length; i++) {
        	if(i != 0) {
        		buffer.append(", ");
        	}
        	if(args[i] != null) {
        	    if(fullDisplay) {
        	        buffer.append(args[i].getQualifiedName());
        	    } else {
        	        buffer.append(args[i].getShortName());
        	    }
        	} else {
				buffer.append("null");
        	}
        }
        buffer.append(")");
		return buffer.toString();
	}
	
	public static IRtti[] convertArray(Object[] objs) {
		IRtti[] rttiArgs = new IRtti[objs.length];
		for(int i = 0; i < objs.length; i++) {
			Object obj = objs[i];
			if(obj instanceof IRtti) {
				rttiArgs[i] = (IRtti)obj;
			} else {
				rttiArgs[i] = null;
			}
		}
		return rttiArgs;
	}

    public static IRtti getComponentRtti(Element element) {
        while (element != null){
            if(element instanceof ComponentElement) {
                ComponentElement component = (ComponentElement)element;
    		    return (IRtti)component.getAdapter(IRtti.class);
            }
            element = element.getParent();
        } 
	    return null;
    }

    public static IRtti[] getMethodArgRttis(MethodElement method) {
		List args = method.getArgList();
		IRtti[] rttis = new IRtti[args.size()];
		for(int i = 0; i < rttis.length; i++) {
			rttis[i] = (IRtti)((ArgElement)args.get(i)).getAdapter(IRtti.class);
		}
		return rttis;
	}

	public static boolean hasPropertyElement(
	        ComponentElement component, String name) {
	    if(name != null) {
	        List list = component.getPropertyList();
	        for(Iterator it = list.iterator(); it.hasNext();) {
	            PropertyElement element = (PropertyElement)it.next();
	            if(name.equals(element.getPropertyName())) {
	                return true;
	            }
	        }
	    }
        return false;
	}
	
	public static String getInjectedElementName(IRtti component) {
	    if(component == null) {
	        return "null";
	    } else {
	    	DiconElement element = 
	    		(DiconElement)component.getAdapter(ComponentElement.class);
	    	if(element == null) {
	    		element = (DiconElement)component.getAdapter(ContainerElement.class);
	    	}
	        if(element != null) {
	            return element.getDisplayName() + 
	            	"(@" + element.getContainerElement().getDisplayName() + ")";
	        } else {
	            return component.getQualifiedName();
	        }
	    }
	}
	
    public static List getParentContaienrs(ContainerElement container) {
        List list = new ArrayList();
        IProject project = (IProject)container.getAdapter(IProject.class);
        IStorage storage = (IStorage)container.getAdapter(IStorage.class);
        if((project != null) && (storage != null)) {
	        DiconNature nature = DiconNature.getInstance(project);
	        if(nature != null) {
	        	ModelManager model = nature.getModel();
	        	IStorage[] relateds = model.getRelatedFiles(storage, false);
	            for(int i = 0; i < relateds.length; i++) {
	                ContainerElement parent = model.getContainer(relateds[i], null);
	                list.add(parent);
	            }
	        }
        }
        return list;
    }

    public static ContainerElement getContainer(IProject project, IStorage storage) {
    	DiconNature nature = DiconNature.getInstance(project);
    	if(nature != null) {
    		return nature.getModel().getContainer(storage, null);
    	}
    	return null;
    }
    
}