/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.util;

import java.io.File;
import java.io.InputStream;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class FileUtils implements ConstCore {

    public static IFile createFile(
    		IPackageFragment pack, String fileName, InputStream contents) {
    	try {
    		IContainer folder = (IContainer) pack.getUnderlyingResource();
    		IFile file = folder.getFile(new Path(fileName));
    		file.create(contents, false, null);
    		return file;
    	} catch (CoreException e) {
    		Kijimuna.reportException(e);
    		return null;
    	}
    }
    
	public static String getShortName(IStorage storage) {
	    String name = storage.getName();
	    int pos = name.indexOf(".");
	    if(pos != -1) {
	        name = name.substring(0, pos); 
	    }
	    return name;
	}

    public static boolean isInJavaSourceFolder(IFile file) {
        IContainer container = file.getParent();
    	return (container != null) && (JavaCore.create(container) != null);
    }

    public static boolean isJavaFile(IStorage storage) {
		String fileExt = storage.getFullPath().getFileExtension();
		return "java".equalsIgnoreCase(fileExt);
    }

    public static boolean isDiconFile(IStorage storage) {
		String fileExt = storage.getFullPath().getFileExtension();
		return EXT_DICON.equalsIgnoreCase(fileExt);
    }
    
    public static void deleteAllFiles(IPath path) {
		File directory = path.toFile();
		if(directory.exists()) {
		    deleteDirectory(directory);
		}
    }
    
    private static void deleteDirectory(File directory) {
		File[] files = directory.listFiles();
		for(int i = 0; i < files.length; i++) {
			if(files[i].isDirectory()) {
			    deleteDirectory(files[i]);
			} else {
			    files[i].delete();
			}
		}
		directory.delete();
    }
    
}
