/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.util.ProjectUtils;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class ProjectRecorder implements ISaveParticipant, ConstCore {
    
    private Plugin plugin;
    
    public ProjectRecorder(Plugin plugin) {
        this.plugin = plugin;
    }
    
	private IPath getRecorderFolderPath() {
	    IPath ret = plugin.getStateLocation().append(RECORDER_FOLDERNAME);
	    ret.toFile().mkdirs();
	    return ret;
	}
	
    private void handlerWorkspaceRecordable(
    		ISaveContext saveContext, int type, IProgressMonitor monitor) {
        int kind = ISaveContext.FULL_SAVE;
        if(saveContext != null) {
            kind = saveContext.getKind();
        }
        if(kind == ISaveContext.PROJECT_SAVE) {
            IProject project = saveContext.getProject();
            handleProjectRecordable(project, type, monitor);
        } else if(kind == ISaveContext.FULL_SAVE) {
            IProject[] projects = ProjectUtils.getAllProjects();
            for(int i = 0; i < projects.length; i++) {
                handleProjectRecordable(projects[i], type, monitor);
            }
        }
    }

    private void handleProjectRecordable(
    		IProject project, int type, IProgressMonitor monitor) {
        if(project.isOpen()) {
	        String[] natureIds = ProjectUtils.getNatureIds(project);
	        for(int i = 0; i < natureIds.length; i++) {
	            try {
	                IProjectNature nature = project.getNature(natureIds[i]);
	                if(nature instanceof IProjectRecordable) {
	                    IProjectRecordable recordable = (IProjectRecordable)nature;
	                    IPath path = getRecorderFolderPath();
	                    if(type == RECORDER_EVENT_INIT) {
	                   	    recordable.initProjectRecords(monitor);
	                    } else if(type == RECORDER_EVENT_RESTORE) {
	                   	    if(!recordable.restoreProjectRecords(path, monitor)) {
	                   	        recordable.initProjectRecords(monitor);
	                   	    }
	                    } else if(type == RECORDER_EVENT_SAVE) {
	                   	    recordable.saveProjectRecords(path, monitor);
	                    } else {
	                        recordable.customProcess(type, path, monitor);
	                    }
	                }
	            } catch (Exception e) {
	            }
	        }
        }
    }
    
    public void inithialize(IProgressMonitor monitor) {
       	handlerWorkspaceRecordable(null, RECORDER_EVENT_RESTORE, monitor);
    }

    public void cleanup(IProgressMonitor monitor) {
       	handlerWorkspaceRecordable(null, RECORDER_EVENT_INIT, monitor);
    }
    
    public void cleanup(IProject project, IProgressMonitor monitor) {
        handleProjectRecordable(project, RECORDER_EVENT_INIT, monitor);
    }
    
    public void validate(IProject project, IProgressMonitor monitor) {
        handleProjectRecordable(project, RECORDER_VALIDATE, monitor);
    }
    
    public void saving(ISaveContext saveContext) throws CoreException {
        handlerWorkspaceRecordable(saveContext, RECORDER_EVENT_SAVE, null);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }
    
    public void doneSaving(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }
}
