/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.preference;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class PluginPreferences extends EclipsePreferences {

	private static Set loadedNodes = new HashSet();
	
    private String pluginID;
    private String qualifier;
    private IEclipsePreferences loadLevel;
    private int segmentCount;
    
    public PluginPreferences() {
        super(null, null);
    }
    
    private PluginPreferences(
            IEclipsePreferences parent, String name) {
		super(parent, name);
        String path = absolutePath();
		segmentCount = getSegmentCount(path);
		if (segmentCount < 2) {
			return;
		}
		pluginID = getSegment(path, 1);
		if (segmentCount > 2) {
		    qualifier = getSegment(path, 2);
		}
    }

	protected EclipsePreferences internalCreate(
	        IEclipsePreferences nodeParent, String nodeName, Plugin context) {
	    return new PluginPreferences(nodeParent, nodeName);
	}

	protected IPath getLocation() {
		if (pluginID == null || qualifier == null) {
			return null;
		}
		IPath path = ResourcesPlugin.getPlugin().getStateLocation();
		path = path.removeLastSegments(1).append(pluginID);
		return computeLocation(path, qualifier);
	}

    protected IEclipsePreferences getLoadLevel() {
		if (loadLevel == null) {
			if (pluginID == null || qualifier == null) {
				return null;
			}
			IEclipsePreferences node = this;
			for (int i = 3; i < segmentCount; i++) {
				node = (IEclipsePreferences) node.parent();
			}
			loadLevel = node;
		}
		return loadLevel;
    }

	protected void loaded() {
		loadedNodes.add(name());
	}

	protected boolean isAlreadyLoaded(IEclipsePreferences node) {
		return loadedNodes.contains(node.name());
	}
    
}
