/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.preference;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.seasar.kijimuna.core.Kijimuna;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class CascadePreferences implements IPreferences {

	private IEclipsePreferences pref;
	private IEclipsePreferences defaultPref;
	private IEclipsePreferences basePref;

	public CascadePreferences(IEclipsePreferences pref,
	        IEclipsePreferences defaultPref) {
	    this(pref, defaultPref, null);
	}	
	
	public CascadePreferences(IEclipsePreferences pref,
			IEclipsePreferences defaultPref, IEclipsePreferences basePref) {
	    if((pref == null) || (defaultPref == null)) {
	        throw new IllegalArgumentException();
	    }
		this.pref = pref;
		this.defaultPref = defaultPref;
		this.basePref = basePref;
	}

	public String getDefault(String key) {
		if(basePref == null) {
			return defaultPref.get(key, "");
		}
		return defaultPref.get(key, basePref.get(key, ""));
	}

	public boolean getDefaultBoolean(String key) {
		if(basePref == null) {
			return defaultPref.getBoolean(key, false);
		}
		return defaultPref.getBoolean(key, basePref.getBoolean(key, false));
	}
	
	public byte[] getDefaultByteArray(String key) {
		if(basePref == null) {
			return defaultPref.getByteArray(key, new byte[0]);
		}
		return defaultPref.getByteArray(key, basePref.getByteArray(key, new byte[0]));
	}
	
	public double getDefaultDouble(String key) {
		if(basePref == null) {
			return defaultPref.getDouble(key, 0);
		}
		return defaultPref.getDouble(key, basePref.getDouble(key, 0));
	}
	
	public float getDefaultFloat(String key) {
		if(basePref == null) {
			return defaultPref.getFloat(key, 0);
		}
		return defaultPref.getFloat(key, basePref.getFloat(key, 0));
	}
	
	public int getDefaultInt(String key) {
		if(basePref == null) {
			return defaultPref.getInt(key, 0);
		}
		return defaultPref.getInt(key, basePref.getInt(key, 0));
	}
	
	public long getDefaultLong(String key) {
		if(basePref == null) {
			return defaultPref.getLong(key, 0);
		}
		return defaultPref.getLong(key, basePref.getLong(key, 0));
	}

	public void putDefault(String key, String value) {
		defaultPref.put(key, value);
	}
	
	public void putDefaultBoolean(String key, boolean value) {
		defaultPref.putBoolean(key, value);
	}
	
	public void putDefaultByteArray(String key, byte[] value) {
		defaultPref.putByteArray(key, value);
	}
	
	public void putDefaultDouble(String key, double value) {
		defaultPref.putDouble(key, value);
	}
	
	public void putDefaultFloat(String key, float value) {
		defaultPref.putFloat(key, value);
	}
	
	public void putDefaultInt(String key, int value) {
		defaultPref.putInt(key, value);
	}
	
	public void putDefaultLong(String key, long value) {
		defaultPref.putLong(key, value);
	}

	public void removeDefault(String key) {
		defaultPref.remove(key);
	}	

	public void clearDefault() {
		try {
			defaultPref.clear();
		} catch (BackingStoreException e) {
			Kijimuna.reportException(e);
		}
	}
	
	public String get(String key) {
		return pref.get(key, getDefault(key));
	}

	public boolean getBoolean(String key) {
		return pref.getBoolean(key, getDefaultBoolean(key));
	}
	
	public byte[] getByteArray(String key) {
		return pref.getByteArray(key, getDefaultByteArray(key));
	}
	
	public double getDouble(String key) {
		return pref.getDouble(key, getDefaultDouble(key));
	}
	
	public float getFloat(String key) {
		return pref.getFloat(key, getDefaultFloat(key));
	}
	
	public int getInt(String key) {
		return pref.getInt(key, getDefaultInt(key));
	}
	
	public long getLong(String key) {
		return pref.getLong(key, getDefaultLong(key));
	}
	
	public void put(String key, String value) {
        pref.put(key, value);
	}
	
	public void putBoolean(String key, boolean value) {
        pref.putBoolean(key, value);
	}
	
	public void putByteArray(String key, byte[] value) {
        pref.putByteArray(key, value);
	}
	
	public void putDouble(String key, double value) {
        pref.putDouble(key, value);
	}
	
	public void putFloat(String key, float value) {
        pref.putFloat(key, value);
	}
	
	public void putInt(String key, int value) {
        pref.putInt(key, value);
	}
	
	public void putLong(String key, long value) {
        pref.putLong(key, value);
	}

	public void remove(String key) {
        pref.remove(key);
	}	

	public void clear() {
		try {
	        pref.clear();
		} catch (BackingStoreException e) {
			Kijimuna.reportException(e);
		}
	}
	
	public void flash() {
		try {
			pref.flush();
			defaultPref.flush();
		} catch (BackingStoreException e) {
			Kijimuna.reportException(e);
		}
	}
}
