/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.parser;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.Kijimuna;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class DocumentParser {

	private static SAXParserFactory factory;

	public Element parse(InputStream stream, String systemID, 
			IProgressMonitor monitor, DocumentHandler handler) {
	    if((stream == null) || (handler == null)) {
	        return null;
	    }
		handler.setProgressMonitor(monitor);
		try {
			InputSource source = new InputSource(stream);
			if(systemID != null) {
			    source.setSystemId(systemID);
			}
			getParser().parse(source, handler);
		} catch (StopParse stop) {
		} catch (Exception e) {
			Kijimuna.reportException(e);
		} finally {
			try {
				stream.close();
			} catch (IOException e) {
				Kijimuna.reportException(e);
			}
		}
		return handler.getResult();
	}
	
	public Element parse(IProject project, IStorage storage, IProgressMonitor monitor, 
			DocumentHandler handler) {
		if (storage == null) {
			return null;
		}
		if (handler != null) {
			handler.setStorage(project, storage);
		} else {
			return null;
		}
		try {
			InputStream stream = storage.getContents();
			String systemID = storage.getFullPath().toString(); 
			return parse(stream, systemID, monitor, handler);
		} catch (Exception e) {
			Kijimuna.reportException(e);
			return null;
		}
	}

	private SAXParser getParser() throws ParserConfigurationException,
			SAXException {
		if (factory == null) {
			factory = SAXParserFactory.newInstance();
			factory.setValidating(true);
		}
		return factory.newSAXParser();
	}

}