/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core.dicon.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.seasar.kijimuna.core.dicon.IComponentKey;
import org.seasar.kijimuna.core.dicon.IComponentNotFound;
import org.seasar.kijimuna.core.dicon.IDirectAccessed;
import org.seasar.kijimuna.core.dicon.ITooManyRegisted;
import org.seasar.kijimuna.core.dicon.ModelManager;
import org.seasar.kijimuna.core.dicon.tools.ContainerPropertyAccessor;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.RttiWrapper;
import org.seasar.kijimuna.core.rtti.ognl.OgnlRtti;
import org.seasar.kijimuna.core.rtti.ognl.OgnlRttiUnprocessable;
import org.seasar.kijimuna.core.util.StringUtils;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public abstract class AbstractExpressionElement extends DiconElement {

	private static transient ContainerPropertyAccessor accessor;

	private static ContainerPropertyAccessor getAccessor() {
		if(accessor == null) {
			accessor = new ContainerPropertyAccessor();
		}
		return accessor;
	}
	
	private String message;
	private IRtti rtti;
	
	protected AbstractExpressionElement(
	        IProject project, IStorage storage, String elementName) {
		super(project, storage, elementName);
	}

	public boolean hasError() {
	    return message != null;
	}
	
	public String getErrorMessage() {
	    return message;
	}
	
	protected abstract IRtti getNonExpressionValue() throws Exception;

    public Object getAdapter(Class adapter) {
        if(IRtti.class.equals(adapter)) {
            if((rtti == null) || !isLocking()) {
	    		String el = getExpression();
	    		try {
	    			message = null;
	    		    if(StringUtils.existValue(el)) {
	    				OgnlRtti ognlRtti = new OgnlRtti(getRttiLoader());
	    				ognlRtti.setPropertyAccessor(ContainerElement.class, getAccessor());
	    				ognlRtti.setPropertyAccessor(RttiWrapper.class, getAccessor());
	    				rtti = ognlRtti.getValue(getContainerElement(), el);
	    			} else {
	    			    rtti = getNonExpressionValue();
	    			}
	    		    if(rtti != null) {
		    		    IStorage java = (IStorage)rtti.getAdapter(IStorage.class);
		    		    if(java != null) {
		    		        ModelManager model = getNature().getModel();
		    		        model.addContainerAndRelatedFile(getContainerElement(), java);
		    		    }
	    		    }
	    		} catch (OgnlRttiUnprocessable ignore) {
	    		} catch (Exception e) {
	    			message = e.getMessage();
	    		}
            }
    		return rtti;
        }
        return super.getAdapter(adapter);
    }

	public String getDisplayName() {
		StringBuffer buffer = new StringBuffer();
		if(isOGNL()) {
			String expression = getExpression();
		        buffer.append(expression);
		} else {
			IRtti value = (IRtti)getAdapter(IRtti.class);
	        if((value instanceof IComponentNotFound) ||
	                (value instanceof ITooManyRegisted)) {
				buffer.append(value.getAdapter(IComponentKey.class));
	        } else {
	            buffer.append(value.getQualifiedName());
	        }
		}
		return buffer.toString();
	}

	public boolean isOGNL() {
		String expression = getExpression();
	    if(StringUtils.existValue(expression)) {
			IRtti value = (IRtti)getAdapter(IRtti.class);
			if((value instanceof IComponentNotFound) ||
	                (value instanceof ITooManyRegisted)) {
	            return false;
	        } else if(!(value instanceof IDirectAccessed)) {
	            return true;
	        }
	    }
	    return false;	
	}
	
}
