/*
 * 
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endour or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.kijimuna.core;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class MessageManager {
	
	private Plugin plugin;
	private String resourceBaseName;
	private String pluginID;
	private ResourceBundle bundle;
	
	public MessageManager(Plugin plugin, String resourceBaseName) {
		this.plugin = plugin;
		this.resourceBaseName = resourceBaseName;
	}

	public void reportInfo(String message) {
		try {
			IStatus status = new Status(IStatus.INFO, pluginID, IStatus.OK, message, null);
			plugin.getLog().log(status);
        } catch (RuntimeException e1) {
        }
	}
	
	public void reportException(Exception e) {
		try {
            IStatus status;
            if (e instanceof CoreException) {
            	status = ((CoreException) e).getStatus();
            } else {
            	status = new Status(IStatus.ERROR, pluginID, IStatus.OK,
            	        e.getMessage(), e);
            }
            plugin.getLog().log(status);
        } catch (RuntimeException e1) {
        }
	}

	public String getResourceString(String key) {
		try {
			if(bundle == null) {
				bundle = ResourceBundle.getBundle(resourceBaseName, 
						Locale.getDefault(), plugin.getClass().getClassLoader());
			}
			return bundle.getString(key);
		} catch (Exception e) {
			return "!" + key + "!";
		}
	}
	
	public String getResourceString(String key, Object[] args) {
	    if(args == null) {
	        args = new Object[0];
	    }
	    return MessageFormat.format(getResourceString(key), args);
	}

}
