/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.el.parser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.ognl.el.Environment;
import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.OgnlException;
import org.ognl.el.parser.SimpleNode;

public class ASTStaticField
extends SimpleNode {
    private String className;
    private String fieldName;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    protected Object getValueBody(ExecutionEnvironment environment, Object source) throws OgnlException {
        return environment.getExtensions().getStaticFieldValue(environment, this.getClassName(), this.getFieldName());
    }

    public boolean isConstant(Environment environment) throws OgnlException {
        boolean result = false;
        if (!this.getFieldName().equals("class")) {
            Field f = null;
            if (environment != null) {
                Class c = environment.getClassResolver().classForName(environment, this.getClassName());
                f = environment.getReflector().getField(c, this.getFieldName());
            } else {
                try {
                    Class<?> c = Class.forName(this.getClassName());
                    f = c.getField(this.getFieldName());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (f != null) {
                int modifiers = f.getModifiers();
                boolean bl = false;
                if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                    bl = true;
                }
                result = bl;
            }
        }
        return result;
    }

    public String toString() {
        return "@" + this.getClassName() + '@' + this.getFieldName();
    }

    public ASTStaticField(int id) {
        super(id);
    }
}

