/*
 * Decompiled with CFR 0.152.
 */
package org.ognl.el.extensions;

import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.Extensions;
import org.ognl.el.NoSuchPropertyException;
import org.ognl.el.OgnlException;
import org.ognl.el.extensions.AbstractPropertyAccessor;
import org.ognl.util.RuntimeUtils;

public class DefaultPropertyAccessor
extends AbstractPropertyAccessor {
    public Object getPossibleProperty(ExecutionEnvironment environment, Object target, String propertyName) throws OgnlException {
        Object result;
        Extensions extensions = environment.getExtensions();
        try {
            result = extensions.getMethodPropertyValue(environment, target, propertyName);
            if (result == RuntimeUtils.NotFound) {
                result = extensions.getFieldPropertyValue(environment, target, propertyName);
            }
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(propertyName, ex);
        }
        return result;
    }

    public Object setPossibleProperty(ExecutionEnvironment environment, Object target, String propertyName, Object value) throws OgnlException {
        Object result = null;
        Extensions extensions = environment.getExtensions();
        try {
            if (!extensions.setMethodPropertyValue(environment, target, propertyName, value)) {
                result = extensions.setFieldPropertyValue(environment, target, propertyName, value);
            }
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(propertyName, ex);
        }
        return result;
    }

    public Object getPropertyValue(ExecutionEnvironment environment, Object source, Object property) throws OgnlException {
        Object result;
        if (!(property instanceof String) || (result = this.getPossibleProperty(environment, source, (String)property)) == RuntimeUtils.NotFound) {
            throw new NoSuchPropertyException(source, property);
        }
        return result;
    }

    public Object getIndexedPropertyValue(ExecutionEnvironment environment, Object source, Object index) throws OgnlException {
        return this.getPropertyValue(environment, source, index);
    }

    public Object getNamedIndexedPropertyValue(ExecutionEnvironment environment, Object source, String propertyName, Object index) throws OgnlException {
        Extensions extensions = environment.getExtensions();
        int indexedPropertyType = environment.getReflector().getIndexedPropertyType(source.getClass(), propertyName);
        Object result = indexedPropertyType == 0 ? extensions.getIndexedPropertyValue(environment, extensions.getPropertyValue(environment, source, propertyName), index) : extensions.getBeansIndexedPropertyValue(environment, source, propertyName, index);
        return result;
    }

    public void setPropertyValue(ExecutionEnvironment environment, Object target, Object property, Object value) throws OgnlException {
        if (!(property instanceof String) || this.setPossibleProperty(environment, target, (String)property, value) == RuntimeUtils.NotFound) {
            throw new NoSuchPropertyException(target, property);
        }
    }

    public void setIndexedPropertyValue(ExecutionEnvironment environment, Object target, Object index, Object value) throws OgnlException {
        this.setPropertyValue(environment, target, index, value);
    }

    public void setNamedIndexedPropertyValue(ExecutionEnvironment environment, Object target, String propertyName, Object index, Object value) throws OgnlException {
        Extensions extensions = environment.getExtensions();
        int indexedPropertyType = environment.getReflector().getIndexedPropertyType(target.getClass(), propertyName);
        if (indexedPropertyType == 0) {
            extensions.setIndexedPropertyValue(environment, extensions.getPropertyValue(environment, target, propertyName), index, value);
        } else {
            extensions.setBeansIndexedPropertyValue(environment, target, propertyName, index, value);
        }
    }
}

