/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.seasar.kijimuna.core.dicon.DiconNature;
import org.seasar.kijimuna.core.dicon.ModelManager;
import org.seasar.kijimuna.core.dicon.model.ArgElement;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.dicon.model.DiconElement;
import org.seasar.kijimuna.core.dicon.model.MethodElement;
import org.seasar.kijimuna.core.dicon.model.PropertyElement;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;

public class ModelUtils {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static String getMethodDisplay(IRttiMethod method, boolean fullDisplay) {
        return ModelUtils.getMethodDisplay(method.getParent(), method.getMethodName(), method.getArgs(), fullDisplay);
    }

    public static String getMethodDisplay(IRtti component, String methodName, IRtti[] args, boolean fullDisplay) {
        StringBuffer buffer = new StringBuffer();
        if (fullDisplay) {
            buffer.append(component.getQualifiedName()).append("#");
        }
        buffer.append(methodName).append("(");
        int i = 0;
        while (i < args.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            if (args[i] != null) {
                if (fullDisplay) {
                    buffer.append(args[i].getQualifiedName());
                } else {
                    buffer.append(args[i].getShortName());
                }
            } else {
                buffer.append("null");
            }
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static IRtti[] convertArray(Object[] objs) {
        IRtti[] rttiArgs = new IRtti[objs.length];
        int i = 0;
        while (i < objs.length) {
            Object obj = objs[i];
            rttiArgs[i] = obj instanceof IRtti ? (IRtti)obj : null;
            ++i;
        }
        return rttiArgs;
    }

    public static IRtti getComponentRtti(Element element) {
        while (element != null) {
            if (element instanceof ComponentElement) {
                ComponentElement component = (ComponentElement)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (IRtti)component.getAdapter(clazz);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IRtti[] getMethodArgRttis(MethodElement method) {
        List args = method.getArgList();
        IRtti[] rttis = new IRtti[args.size()];
        int i = 0;
        while (i < rttis.length) {
            ArgElement argElement = (ArgElement)args.get(i);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rttis[i] = (IRtti)argElement.getAdapter(clazz);
            ++i;
        }
        return rttis;
    }

    public static boolean hasPropertyElement(ComponentElement component, String name) {
        if (name != null) {
            List list = component.getPropertyList();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                PropertyElement element = (PropertyElement)it.next();
                if (!name.equals(element.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getInjectedElementName(IRtti component) {
        DiconElement element;
        if (component == null) {
            return "null";
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.model.ComponentElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = (DiconElement)component.getAdapter(clazz)) == null) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.seasar.kijimuna.core.dicon.model.ContainerElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            element = (DiconElement)component.getAdapter(clazz2);
        }
        if (element != null) {
            return String.valueOf(element.getDisplayName()) + "(@" + element.getContainerElement().getDisplayName() + ")";
        }
        return component.getQualifiedName();
    }

    public static List getParentContaienrs(ContainerElement container) {
        DiconNature nature;
        ArrayList<ContainerElement> list = new ArrayList<ContainerElement>();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject project = (IProject)container.getAdapter(clazz);
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IStorage storage = (IStorage)container.getAdapter(clazz2);
        if (project != null && storage != null && (nature = DiconNature.getInstance(project)) != null) {
            ModelManager model = nature.getModel();
            IFile[] relateds = model.getRelatedFiles(storage, false);
            int i = 0;
            while (i < relateds.length) {
                ContainerElement parent = model.getContainer((IStorage)relateds[i], null);
                list.add(parent);
                ++i;
            }
        }
        return list;
    }

    public static ContainerElement getContainer(IProject project, IStorage storage) {
        DiconNature nature = DiconNature.getInstance(project);
        if (nature != null) {
            return nature.getModel().getContainer(storage, null);
        }
        return null;
    }
}

