/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.util;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;

public class FileUtils
implements ConstCore {
    public static IFile createFile(IPackageFragment pack, String fileName, InputStream contents) {
        try {
            IContainer folder = (IContainer)pack.getUnderlyingResource();
            IFile file = folder.getFile((IPath)new Path(fileName));
            file.create(contents, false, null);
            return file;
        }
        catch (CoreException e) {
            Kijimuna.reportException((Exception)((Object)e));
            return null;
        }
    }

    public static String getShortName(IStorage storage) {
        String name = storage.getName();
        int pos = name.indexOf(".");
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public static boolean isInJavaSourceFolder(IFile file) {
        IContainer container = file.getParent();
        return container != null && JavaCore.create((IResource)container) != null;
    }

    public static boolean isJavaFile(IStorage storage) {
        String fileExt = storage.getFullPath().getFileExtension();
        return "java".equalsIgnoreCase(fileExt);
    }

    public static boolean isDiconFile(IStorage storage) {
        String fileExt = storage.getFullPath().getFileExtension();
        return "dicon".equalsIgnoreCase(fileExt);
    }

    public static void deleteAllFiles(IPath path) {
        File directory = path.toFile();
        if (directory.exists()) {
            FileUtils.deleteDirectory(directory);
        }
    }

    private static void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                FileUtils.deleteDirectory(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
        directory.delete();
    }
}

