/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti.ognl;

import org.ognl.el.ExecutionEnvironment;
import org.ognl.el.Extensions;
import org.ognl.el.MethodFailedException;
import org.ognl.el.OgnlException;
import org.ognl.el.PropertyAccessor;
import org.ognl.util.ClassRegistry;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.RttiClassNotFoundException;
import org.seasar.kijimuna.core.rtti.RttiLoader;
import org.seasar.kijimuna.core.rtti.RttiNoSuchFieldException;
import org.seasar.kijimuna.core.rtti.RttiNoSuchMethodException;
import org.seasar.kijimuna.core.rtti.RttiNoSuchPropertyException;
import org.seasar.kijimuna.core.rtti.ognl.OgnlRttiUnprocessable;

public class OgnlExtensions
extends Extensions {
    private RttiLoader loader;
    private ClassRegistry accessors = new ClassRegistry();

    public OgnlExtensions(RttiLoader loader) {
        this.loader = loader;
    }

    private IRtti convert(RttiLoader localLoader, Object obj) throws RttiClassNotFoundException {
        if (obj != null) {
            if (obj instanceof IRtti) {
                return (IRtti)obj;
            }
            return localLoader.loadRtti(obj.getClass());
        }
        return null;
    }

    private IRtti[] convertArgs(RttiLoader localLoader, Object[] args) throws RttiClassNotFoundException {
        if (args != null) {
            IRtti[] rttiArgs = new IRtti[args.length];
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    rttiArgs[i] = this.convert(localLoader, args[i]);
                }
                ++i;
            }
            return rttiArgs;
        }
        return new IRtti[0];
    }

    public void setPropertyAccessor(Class forClass, PropertyAccessor accessor) {
        this.accessors.put(forClass, (Object)accessor);
    }

    private PropertyAccessor getPropertyAccessor(Class forClass) {
        return (PropertyAccessor)this.accessors.get(forClass);
    }

    public Object callArrayConstructor(ExecutionEnvironment environment, String componentClassName, Object[] args) throws OgnlException {
        return this.loader.loadRtti(String.valueOf(componentClassName) + "[]");
    }

    public Object callConstructor(ExecutionEnvironment environment, String targetClassName, Object[] args) throws OgnlException {
        IRtti[] rttiArgs;
        IRtti rtti = this.loader.loadRtti(targetClassName);
        if (rtti.hasConstructor(rttiArgs = this.convertArgs(this.loader, args))) {
            return rtti;
        }
        throw new RttiNoSuchMethodException(targetClassName, rtti.getShortName(), rttiArgs);
    }

    public Object callMethod(ExecutionEnvironment environment, Object target, String methodName, Object[] args) throws MethodFailedException, OgnlException {
        IRtti rtti = this.convert(this.loader, target);
        RttiLoader localLoader = rtti.getRttiLoader();
        IRtti[] rttiArgs = this.convertArgs(localLoader, args);
        return rtti.invoke(methodName, rttiArgs);
    }

    public Object callStaticMethod(ExecutionEnvironment environment, String targetClassName, String methodName, Object[] args) throws MethodFailedException, OgnlException {
        IRtti targetRtti = this.loader.loadRtti(targetClassName);
        return this.callMethod(environment, targetRtti, methodName, args);
    }

    public Object getIndexedPropertyValue(ExecutionEnvironment environment, Object source, Object index) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public Object getNamedIndexedPropertyValue(ExecutionEnvironment environment, Object source, String propertyName, Object index) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public Object getPropertyValue(ExecutionEnvironment environment, Object source, Object property) throws OgnlException {
        PropertyAccessor accessor = this.getPropertyAccessor(source.getClass());
        if (accessor != null) {
            return accessor.getPropertyValue(environment, source, property);
        }
        IRtti rtti = this.convert(this.loader, source);
        try {
            return rtti.getProperty(property.toString());
        }
        catch (RttiNoSuchPropertyException rttiNoSuchPropertyException) {
            return rtti.getField(property.toString(), false);
        }
    }

    public Object getStaticFieldValue(ExecutionEnvironment environment, String targetClassName, String fieldName) throws OgnlException {
        IRtti rtti = this.loader.loadRtti(targetClassName);
        return rtti.getField(fieldName, true);
    }

    public void setIndexedPropertyValue(ExecutionEnvironment environment, Object target, Object index, Object value) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public void setNamedIndexedPropertyValue(ExecutionEnvironment environment, Object target, String propertyName, Object index, Object value) throws OgnlException {
        throw new OgnlRttiUnprocessable();
    }

    public void setPropertyValue(ExecutionEnvironment environment, Object target, Object property, Object value) throws OgnlException {
        PropertyAccessor accessor = this.getPropertyAccessor(target.getClass());
        if (accessor != null) {
            accessor.setPropertyValue(environment, target, property, value);
        } else {
            IRtti rtti = this.convert(this.loader, target);
            IRtti rttiValue = this.convert(this.loader, value);
            if (rtti.hasSetterMethod(property.toString(), rttiValue)) {
                return;
            }
            IRtti field = rtti.getField(property.toString(), false);
            if (!field.isAssignableFrom(rttiValue)) {
                throw new RttiNoSuchFieldException(rtti.getQualifiedName(), value.toString());
            }
        }
    }
}

