/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.seasar.kijimuna.core.rtti.DefaultRtti;
import org.seasar.kijimuna.core.rtti.DefaultRttiCache;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiCache;
import org.seasar.kijimuna.core.rtti.RttiClassNotFoundException;
import org.seasar.kijimuna.core.util.ProjectUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class RttiLoader
implements Serializable {
    private static final int ERROR = -1;
    private static final Map PRIMITIVES = new HashMap();
    private boolean autoConvert;
    private String projectName;
    private String hostName;
    private transient IJavaProject project;
    private transient IType host;
    private IRttiCache cache;

    static {
        PRIMITIVES.put("boolean", "java.lang.Boolean");
        PRIMITIVES.put("byte", "java.lang.Byte");
        PRIMITIVES.put("char", "java.lang.Character");
        PRIMITIVES.put("double", "java.lang.Double");
        PRIMITIVES.put("float", "java.lang.Float");
        PRIMITIVES.put("int", "java.lang.Integer");
        PRIMITIVES.put("long", "java.lang.Long");
        PRIMITIVES.put("short", "java.lang.Short");
        PRIMITIVES.put("void", "java.lang.Void");
    }

    public RttiLoader(String projectName, boolean autoConvert) {
        this(projectName, autoConvert, new DefaultRttiCache(), null);
    }

    private RttiLoader(String projectName, boolean autoConvert, IRttiCache cache, String hostName) {
        this.projectName = projectName;
        this.autoConvert = autoConvert;
        this.hostName = hostName;
        this.cache = cache;
    }

    public IRttiCache getRttiCache() {
        return this.cache;
    }

    private String createKey(String fullQualifiedName, boolean primitive, int arrayDepth, String loaderHostName) {
        StringBuffer buffer = new StringBuffer(fullQualifiedName);
        buffer.append("/").append(primitive);
        if (arrayDepth > 0) {
            buffer.append("/").append(arrayDepth).append("/").append(loaderHostName);
        }
        return buffer.toString();
    }

    private IRtti cacheGet(String fullQualifiedName, boolean primitive, int arrayDepth, String loaderHostName) {
        String key = this.createKey(fullQualifiedName, primitive, arrayDepth, loaderHostName);
        return this.getRttiCache().getRttiFromCache(key);
    }

    private void cachePut(String fullQualifiedName, boolean primitive, int arrayDepth, String loaderHostName, IRtti rtti) {
        String key = this.createKey(fullQualifiedName, primitive, arrayDepth, loaderHostName);
        this.getRttiCache().putRttiToCache(key, rtti);
    }

    private IType getHost() {
        if (this.host == null && StringUtils.existValue(this.hostName)) {
            try {
                this.host = this.getProject().findType(this.hostName);
            }
            catch (JavaModelException javaModelException) {
                throw new RttiClassNotFoundException(this.hostName);
            }
        }
        return this.host;
    }

    public IJavaProject getProject() {
        if (this.project == null) {
            this.project = ProjectUtils.getJavaProject(this.projectName);
        }
        return this.project;
    }

    public boolean isAutoConvert() {
        return this.autoConvert;
    }

    public IRtti loadRtti(Class clazz) throws RttiClassNotFoundException {
        String name = clazz.getName();
        return this.loadRtti(name);
    }

    public IRtti loadRtti(String declareName) throws RttiClassNotFoundException {
        if (declareName == null) {
            throw new RttiClassNotFoundException("(null)");
        }
        declareName = this.removeIgnorableWhitespace(declareName);
        String qualifiedName = null;
        boolean primitive = this.isPrimitive(declareName);
        int arrayDepth = 0;
        String loaderHostName = null;
        if (primitive) {
            qualifiedName = this.getWrapperName(declareName);
            loaderHostName = declareName;
        } else {
            arrayDepth = this.getArrayDepth(declareName);
            if (arrayDepth == -1) {
                throw new RttiClassNotFoundException(declareName);
            }
            if (arrayDepth > 0) {
                qualifiedName = "java.lang.Object";
                loaderHostName = this.getArrayItemName(declareName);
            } else {
                loaderHostName = qualifiedName = this.qualifyName(declareName);
            }
        }
        IRtti cached = this.cacheGet(qualifiedName, primitive, arrayDepth, loaderHostName);
        if (cached == null) {
            try {
                IRtti arrayItemRtti = null;
                if (arrayDepth > 0) {
                    arrayItemRtti = this.getArrayRtti(loaderHostName, arrayDepth - 1);
                }
                IType newType = this.getProject().findType(qualifiedName);
                RttiLoader childLoader = new RttiLoader(this.projectName, this.autoConvert, this.getRttiCache(), qualifiedName);
                cached = new DefaultRtti(childLoader, newType, qualifiedName, primitive, arrayDepth, arrayItemRtti, this.autoConvert);
                this.cachePut(qualifiedName, primitive, arrayDepth, loaderHostName, cached);
            }
            catch (JavaModelException javaModelException) {
                throw new RttiClassNotFoundException(qualifiedName);
            }
        }
        return cached;
    }

    private String removeIgnorableWhitespace(String declareName) {
        declareName = declareName.replaceAll(" ", "");
        declareName = declareName.replaceAll("\r", "");
        declareName = declareName.replaceAll("\n", "");
        declareName = declareName.replaceAll("\t", "");
        return declareName;
    }

    private String qualifyName(String declareName) throws RttiClassNotFoundException {
        IType current = this.getHost();
        if (current != null) {
            try {
                String[][] result = current.resolveType(declareName);
                if (result != null) {
                    String pack = result[0][0];
                    String cname = result[0][1];
                    pack = pack == null || pack.length() == 0 ? "" : String.valueOf(pack) + ".";
                    return String.valueOf(pack) + cname;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return declareName;
    }

    private String getArrayItemName(String declareName) throws RttiClassNotFoundException {
        int pos = declareName.indexOf("[");
        if (pos != -1) {
            String declareItemName = declareName.substring(0, pos);
            return this.qualifyName(declareItemName);
        }
        throw new RttiClassNotFoundException(declareName);
    }

    private int getArrayDepth(String declareName) {
        int depth = 0;
        int pos = declareName.indexOf("[");
        if (pos != -1) {
            String arrayDimension = declareName.substring(pos);
            int i = 0;
            while (i < arrayDimension.length()) {
                char open = arrayDimension.charAt(i);
                if (++i < arrayDimension.length()) {
                    char close = arrayDimension.charAt(i);
                    if (open != '[' || close != ']') {
                        return -1;
                    }
                    ++depth;
                } else {
                    return -1;
                }
                ++i;
            }
        }
        return depth;
    }

    private IRtti getArrayRtti(String itemQualifiedName, int depth) throws RttiClassNotFoundException {
        StringBuffer name = new StringBuffer(itemQualifiedName);
        int i = 0;
        while (i < depth) {
            name.append("[]");
            ++i;
        }
        return this.loadRtti(name.toString());
    }

    private boolean isPrimitive(String declareName) {
        return PRIMITIVES.containsKey(declareName);
    }

    private String getWrapperName(String declareName) {
        return (String)PRIMITIVES.get(declareName);
    }
}

