/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;

class DefaultRttiMethod
implements IRttiMethod {
    private IRtti parent;
    private IRtti[] args;
    private String methodName;
    private IRtti returnType;
    private boolean fFinal;
    private boolean fStatic;
    private IRtti[] values;

    DefaultRttiMethod(IRtti parent, IMethod method, String methodName, IRtti[] args, IRtti returnType) {
        this.parent = parent;
        this.methodName = methodName;
        this.args = args;
        this.returnType = returnType;
        try {
            int flag = method.getFlags();
            this.fFinal = Flags.isFinal((int)flag);
            this.fStatic = Flags.isStatic((int)flag);
        }
        catch (JavaModelException javaModelException) {}
    }

    public IRtti getParent() {
        return this.parent;
    }

    public IRtti[] getArgs() {
        return this.args;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public IRtti getReturnType() {
        return this.returnType;
    }

    public boolean isFinal() {
        return this.fFinal;
    }

    public boolean isStatic() {
        return this.fStatic;
    }

    public int compareTo(Object test) {
        if (test instanceof IRttiMethod) {
            IRttiMethod testMethod = (IRttiMethod)test;
            return this.getMethodName().compareTo(testMethod.getMethodName());
        }
        return 0;
    }

    public IRtti[] getValues() {
        return this.values;
    }

    public void setValues(IRtti[] values) {
        this.values = values;
    }
}

