/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.rtti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.seasar.kijimuna.core.rtti.DefaultRttiMethod;
import org.seasar.kijimuna.core.rtti.DefaultRttiProperty;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;
import org.seasar.kijimuna.core.rtti.IRttiProperty;
import org.seasar.kijimuna.core.rtti.RttiClassNotFoundException;
import org.seasar.kijimuna.core.rtti.RttiLoader;
import org.seasar.kijimuna.core.rtti.RttiNoSuchFieldException;
import org.seasar.kijimuna.core.rtti.RttiNoSuchMethodException;
import org.seasar.kijimuna.core.rtti.RttiNoSuchPropertyException;
import org.seasar.kijimuna.core.util.ProjectUtils;

class DefaultRtti
implements IRtti {
    private static final Map WRAPPERS = new HashMap();
    private transient IType thisType;
    private RttiLoader loader;
    private String projectName;
    private String qualifiedName;
    private boolean primitive;
    private int arrayDepth;
    private IRtti arrayItem;
    private boolean autoConvert;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        WRAPPERS.put("java.lang.Boolean", "boolean");
        WRAPPERS.put("java.lang.Byte", "byte");
        WRAPPERS.put("java.lang.Character", "char");
        WRAPPERS.put("java.lang.Double", "double");
        WRAPPERS.put("java.lang.Float", "float");
        WRAPPERS.put("java.lang.Integer", "int");
        WRAPPERS.put("java.lang.Long", "long");
        WRAPPERS.put("java.lang.Short", "short");
        WRAPPERS.put("java.lang.Void", "void");
    }

    DefaultRtti(RttiLoader loader, IType thisType, String qualifiedName, boolean primitive, int arrayDepth, IRtti arrayItem, boolean autoConvert) throws RttiClassNotFoundException {
        if (loader == null || thisType == null) {
            throw new RttiClassNotFoundException(qualifiedName);
        }
        this.loader = loader;
        this.thisType = thisType;
        this.qualifiedName = qualifiedName;
        this.primitive = primitive;
        this.arrayDepth = arrayDepth;
        this.arrayItem = arrayItem;
        this.autoConvert = autoConvert;
        this.projectName = loader.getProject().getElementName();
    }

    public IType getType() {
        if (this.thisType == null) {
            IJavaProject project = ProjectUtils.getJavaProject(this.projectName);
            try {
                this.thisType = project.findType(this.qualifiedName);
            }
            catch (JavaModelException javaModelException) {}
        }
        return this.thisType;
    }

    public RttiLoader getRttiLoader() {
        return this.loader;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    private boolean isTypeAvailable() {
        return this.getType() != null;
    }

    public boolean isInterface() {
        if (this.isTypeAvailable()) {
            try {
                return this.getType().isInterface();
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    public boolean isFinal() {
        if (this.isTypeAvailable()) {
            try {
                return Flags.isFinal((int)this.getType().getFlags());
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    public String getQualifiedName() {
        if (this.isArray()) {
            StringBuffer buffer = new StringBuffer(this.arrayItem.getQualifiedName());
            int i = 0;
            while (i < this.arrayDepth) {
                buffer.append("[]");
                ++i;
            }
            return buffer.toString();
        }
        if (this.isPrimitive()) {
            return (String)WRAPPERS.get(this.qualifiedName);
        }
        return this.qualifiedName;
    }

    public String getShortName() {
        String qname = this.getQualifiedName();
        int pos = qname.lastIndexOf(46);
        if (pos != -1) {
            return qname.substring(pos + 1);
        }
        return qname;
    }

    public String getWrapperName() {
        return this.qualifiedName;
    }

    public boolean equals(Object test) {
        if (test != null && test instanceof IRtti) {
            IRtti testRtti = (IRtti)test;
            if (this.autoConvert && (this.isPrimitive() || testRtti.isPrimitive()) && this.getWrapperName().equals(testRtti.getWrapperName())) {
                return true;
            }
            if (this.isArray()) {
                if (testRtti.isArray()) {
                    IRtti thisArrayItem = this.getArrayItemClass();
                    IRtti testArrayItem = testRtti.getArrayItemClass();
                    return thisArrayItem.equals(testArrayItem);
                }
                return false;
            }
            String qname = testRtti.getQualifiedName();
            if (this.getQualifiedName().equals(qname)) {
                return true;
            }
        }
        return false;
    }

    public IRtti getArrayItemClass() {
        if (this.isArray()) {
            return this.arrayItem;
        }
        return null;
    }

    public IRtti getSuperClass() {
        if (this.isTypeAvailable() && !this.isInterface() && !this.getQualifiedName().equals("java.lang.Object")) {
            try {
                String superClassName = this.getType().getSuperclassName();
                if (superClassName == null) {
                    superClassName = "java.lang.Object";
                }
                return this.loader.loadRtti(superClassName);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public IRtti[] getInterfaces() {
        if (this.isTypeAvailable()) {
            try {
                String[] interfaces = this.getType().getSuperInterfaceNames();
                IRtti[] ret = new IRtti[interfaces.length];
                int i = 0;
                while (i < interfaces.length) {
                    ret[i] = this.loader.loadRtti(interfaces[i]);
                    ++i;
                }
                return ret;
            }
            catch (Exception exception) {}
        }
        return new IRtti[0];
    }

    private boolean isWideningPrimitiveConversion(IRtti testRtti) {
        String thisQName = this.getQualifiedName();
        String testQName = testRtti.getQualifiedName();
        if (this.autoConvert) {
            if (WRAPPERS.containsKey(thisQName)) {
                thisQName = WRAPPERS.get(thisQName).toString();
            }
            if (WRAPPERS.containsKey(testQName)) {
                testQName = WRAPPERS.get(testQName).toString();
            }
        }
        if (testQName.equals("byte")) {
            return "short,int,long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("short")) {
            return "int,long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("char")) {
            return "int,long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("int")) {
            return "long,float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("long")) {
            return "float,double".indexOf(thisQName) != -1;
        }
        if (testQName.equals("float")) {
            return "double".indexOf(thisQName) != -1;
        }
        return false;
    }

    private boolean isWideningArrayConversion(IRtti testRtti) {
        String thisQName = this.getQualifiedName();
        if (thisQName.equals("java.lang.Object") || thisQName.equals("java.lang.Cloneable") || thisQName.equals("java.io.Serializable")) {
            return true;
        }
        IRtti thisArray = this.getArrayItemClass();
        IRtti testArray = testRtti.getArrayItemClass();
        return thisArray != null && testArray != null && thisArray.isAssignableFrom(testArray);
    }

    public boolean isAssignableFrom(IRtti testRtti) {
        if (testRtti == null) {
            return true;
        }
        if (this.equals(testRtti)) {
            return true;
        }
        if (this.isPrimitive() || testRtti.isPrimitive()) {
            return this.isWideningPrimitiveConversion(testRtti);
        }
        if (testRtti.isArray()) {
            return this.isWideningArrayConversion(testRtti);
        }
        if (this.isInterface()) {
            IRtti[] superInterfaces = testRtti.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                if (this.equals(superInterfaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (!testRtti.isInterface()) {
            IRtti superClass = testRtti.getSuperClass();
            if (superClass == null) {
                return false;
            }
            return this.isAssignableFrom(superClass);
        }
        return false;
    }

    public IRtti getField(String field, boolean staticAccess) throws RttiNoSuchFieldException {
        try {
            if (field.equals("class") && staticAccess) {
                return this.loader.loadRtti("java.lang.Class");
            }
            if (this.isArray() && "length".equals(field)) {
                return this.loader.loadRtti("int");
            }
            if (this.isTypeAvailable()) {
                IField value = this.getType().getField(field);
                if (value.exists() && this.isPublicMember((IMember)value)) {
                    int flags;
                    if (staticAccess && !Flags.isStatic((int)(flags = value.getFlags()))) {
                        throw new RttiNoSuchFieldException(this.getQualifiedName(), field);
                    }
                    String typeSignature = Signature.toString((String)value.getTypeSignature());
                    return this.loader.loadRtti(typeSignature);
                }
                IRtti[] interfaces = this.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    try {
                        return interfaces[i].getField(field, staticAccess);
                    }
                    catch (RttiNoSuchFieldException rttiNoSuchFieldException) {
                        ++i;
                    }
                }
                IRtti superClass = this.getSuperClass();
                if (superClass != null) {
                    return superClass.getField(field, staticAccess);
                }
            }
        }
        catch (Exception exception) {}
        throw new RttiNoSuchFieldException(this.getQualifiedName(), field);
    }

    public IRtti invoke(String methodName, IRtti[] args) throws RttiNoSuchMethodException {
        try {
            IMethod method = this.getMethod(methodName, args);
            if (method != null) {
                String returnType = Signature.toString((String)method.getReturnType());
                return this.loader.loadRtti(returnType);
            }
        }
        catch (Exception exception) {}
        throw new RttiNoSuchMethodException(this.getQualifiedName(), methodName, args);
    }

    public boolean hasConstructor(IRtti[] args) {
        String shortName = this.getShortName();
        boolean ret = this.hasMethod(shortName, args);
        if (!(ret || args != null && args.length != 0)) {
            boolean hasDefault = true;
            try {
                IMethod[] methods = this.getType().getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (this.isPublicMember((IMember)methods[i]) && methods[i].getElementName().equals(shortName)) {
                        hasDefault = false;
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            ret = hasDefault;
        }
        return ret;
    }

    public boolean hasMethod(String methodName, IRtti[] args) {
        IMethod method = this.getMethod(methodName, args);
        return method != null;
    }

    public boolean hasSetterMethod(String property, IRtti arg) {
        IMethod setter = this.getSetterMethod(property, arg);
        return setter != null;
    }

    public boolean hasGetterMethod(String property) {
        IMethod getter = this.getGetterMethod(property);
        return getter != null;
    }

    public IRtti getProperty(String property) throws RttiNoSuchPropertyException {
        IMethod getter = this.getGetterMethod(property);
        if (getter != null) {
            try {
                String propertyType = Signature.toString((String)getter.getReturnType());
                return this.loader.loadRtti(propertyType);
            }
            catch (Exception exception) {}
        }
        throw new RttiNoSuchPropertyException(this.getQualifiedName(), property);
    }

    public IRttiMethod[] getConstructors() {
        return this.getMethods(null, true);
    }

    public IRttiMethod[] getMethods(Pattern pattern) {
        return this.getMethods(pattern, false);
    }

    private IRttiMethod[] getMethods(Pattern pattern, boolean isConstructor) {
        if (this.isTypeAvailable()) {
            try {
                IMethod[] methods = this.getType().getMethods();
                ArrayList<DefaultRttiMethod> list = new ArrayList<DefaultRttiMethod>();
                int i = 0;
                while (i < methods.length) {
                    if (this.isPublicMember((IMember)methods[i])) {
                        String methodName = methods[i].getElementName();
                        if (!(isConstructor ? !methodName.equals(this.getShortName()) : methodName.equals(this.getShortName()) || !pattern.matcher(methodName).matches())) {
                            String[] argTypes = methods[i].getParameterTypes();
                            IRtti[] rttiArgs = new IRtti[argTypes.length];
                            int k = 0;
                            while (k < argTypes.length) {
                                String resolvedName = Signature.toString((String)argTypes[k]);
                                try {
                                    rttiArgs[k] = this.loader.loadRtti(resolvedName);
                                }
                                catch (RttiClassNotFoundException rttiClassNotFoundException) {
                                    rttiArgs[k] = null;
                                }
                                ++k;
                            }
                            String retType = methods[i].getReturnType();
                            String resolvedRet = Signature.toString((String)retType);
                            IRtti retRtti = null;
                            try {
                                retRtti = this.loader.loadRtti(resolvedRet);
                            }
                            catch (RttiClassNotFoundException rttiClassNotFoundException) {}
                            list.add(new DefaultRttiMethod(this, methods[i], methodName, rttiArgs, retRtti));
                        }
                    }
                    ++i;
                }
                Collections.sort(list);
                return list.toArray(new IRttiMethod[list.size()]);
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public IRttiProperty[] getSetterProperties() {
        if (this.isTypeAvailable()) {
            try {
                IRttiProperty[] props;
                IMethod[] methods = this.getType().getMethods();
                ArrayList<IRttiProperty> list = new ArrayList<IRttiProperty>();
                int i = 0;
                while (i < methods.length) {
                    String methodName;
                    String propertyName;
                    if (this.isPublicMember((IMember)methods[i]) && (propertyName = this.getSetterPropertyName(methodName = methods[i].getElementName())) != null) {
                        String[] argTypes = methods[i].getParameterTypes();
                        String retType = Signature.toString((String)methods[i].getReturnType());
                        if ("void".equals(retType) && argTypes.length == 1) {
                            IRtti rttiArg = null;
                            String resolvedName = Signature.toString((String)argTypes[0]);
                            try {
                                rttiArg = this.loader.loadRtti(resolvedName);
                            }
                            catch (RttiClassNotFoundException rttiClassNotFoundException) {}
                            list.add(new DefaultRttiProperty(this, propertyName, rttiArg));
                        }
                    }
                    ++i;
                }
                IRtti parent = this.getSuperClass();
                if (parent != null && (props = parent.getSetterProperties()) != null) {
                    int i2 = 0;
                    while (i2 < props.length) {
                        list.add(props[i2]);
                        ++i2;
                    }
                }
                return list.toArray(new IRttiProperty[list.size()]);
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            IResource resource;
            IType type;
            if (this.isTypeAvailable() && (type = this.getType()) != null && (resource = type.getResource()) != null) {
                return resource;
            }
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(adapter)) {
                return this;
            }
        }
        return null;
    }

    private String getSetterPropertyName(String methodName) {
        if (methodName.startsWith("set")) {
            String propertyName = methodName.substring(3);
            if (propertyName.length() == 0 || Character.isLowerCase(propertyName.charAt(0))) {
                return null;
            }
            if (propertyName.length() == 1 || Character.isLowerCase(propertyName.charAt(1))) {
                char[] chars = propertyName.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                propertyName = new String(chars);
            }
            return propertyName;
        }
        return null;
    }

    private String getAccessorBaseName(String property) {
        char[] chars = property.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private boolean isPublicMember(IMember member) {
        if (!this.isInterface()) {
            try {
                int flags = member.getFlags();
                if (!Flags.isPublic((int)flags)) {
                    return false;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return true;
    }

    private IMethod getGetterMethod(String property) {
        String methodBaseName = this.getAccessorBaseName(property);
        IMethod method = this.getMethod("get" + methodBaseName);
        if (method == null) {
            method = this.getMethod("is" + methodBaseName);
        }
        return method;
    }

    private IMethod getSetterMethod(String property, IRtti test) {
        String setterName = "set" + this.getAccessorBaseName(property);
        IRtti[] arg = null;
        if (test != null) {
            arg = new IRtti[]{test};
        }
        IMethod method = this.getMethod(setterName, arg);
        return method;
    }

    private IMethod getMethod(String methodName) {
        if (this.isTypeAvailable()) {
            IMethod method = this.getType().getMethod(methodName, new String[0]);
            if (!method.exists()) {
                DefaultRtti superClass = (DefaultRtti)this.getSuperClass();
                if (superClass != null) {
                    return superClass.getMethod(methodName);
                }
                return null;
            }
            if (this.isPublicMember((IMember)method)) {
                return method;
            }
        }
        return null;
    }

    private IMethod getMethod(String methodName, IRtti[] args) {
        if (args == null || args.length == 0) {
            return this.getMethod(methodName);
        }
        if (this.isTypeAvailable()) {
            try {
                IMethod[] methods = this.getType().getMethods();
                int i = 0;
                while (i < methods.length) {
                    String[] argTypes;
                    if (this.isPublicMember((IMember)methods[i]) && methods[i].getElementName().equals(methodName) && args.length == (argTypes = methods[i].getParameterTypes()).length) {
                        boolean match = true;
                        int k = 0;
                        while (k < argTypes.length) {
                            block12: {
                                String resolvedName = Signature.toString((String)argTypes[k]);
                                IRtti argRtti = null;
                                try {
                                    argRtti = this.loader.loadRtti(resolvedName);
                                    if (!argRtti.isAssignableFrom(args[k])) {
                                        match = false;
                                    }
                                    break block12;
                                }
                                catch (RttiClassNotFoundException rttiClassNotFoundException) {
                                    match = false;
                                }
                                break;
                            }
                            ++k;
                        }
                        if (match) {
                            return methods[i];
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            DefaultRtti superClass = (DefaultRtti)this.getSuperClass();
            if (superClass != null) {
                return superClass.getMethod(methodName, args);
            }
        }
        return null;
    }
}

