/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.project.IProjectRecordable;
import org.seasar.kijimuna.core.util.ProjectUtils;

public class ProjectRecorder
implements ISaveParticipant,
ConstCore {
    private Plugin plugin;

    public ProjectRecorder(Plugin plugin) {
        this.plugin = plugin;
    }

    private IPath getRecorderFolderPath() {
        IPath ret = this.plugin.getStateLocation().append(".recorder");
        ret.toFile().mkdirs();
        return ret;
    }

    private void handlerWorkspaceRecordable(ISaveContext saveContext, int type, IProgressMonitor monitor) {
        int kind = 1;
        if (saveContext != null) {
            kind = saveContext.getKind();
        }
        if (kind == 3) {
            IProject project = saveContext.getProject();
            this.handleProjectRecordable(project, type, monitor);
        } else if (kind == 1) {
            IProject[] projects = ProjectUtils.getAllProjects();
            int i = 0;
            while (i < projects.length) {
                this.handleProjectRecordable(projects[i], type, monitor);
                ++i;
            }
        }
    }

    private void handleProjectRecordable(IProject project, int type, IProgressMonitor monitor) {
        if (project.isOpen()) {
            String[] natureIds = ProjectUtils.getNatureIds(project);
            int i = 0;
            while (i < natureIds.length) {
                try {
                    IProjectNature nature = project.getNature(natureIds[i]);
                    if (nature instanceof IProjectRecordable) {
                        IProjectRecordable recordable = (IProjectRecordable)nature;
                        IPath path = this.getRecorderFolderPath();
                        if (type == 0) {
                            recordable.initProjectRecords(monitor);
                        } else if (type == 1) {
                            if (!recordable.restoreProjectRecords(path, monitor)) {
                                recordable.initProjectRecords(monitor);
                            }
                        } else if (type == 2) {
                            recordable.saveProjectRecords(path, monitor);
                        } else {
                            recordable.customProcess(type, path, monitor);
                        }
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
    }

    public void inithialize(IProgressMonitor monitor) {
        this.handlerWorkspaceRecordable(null, 1, monitor);
    }

    public void cleanup(IProgressMonitor monitor) {
        this.handlerWorkspaceRecordable(null, 0, monitor);
    }

    public void cleanup(IProject project, IProgressMonitor monitor) {
        this.handleProjectRecordable(project, 0, monitor);
    }

    public void validate(IProject project, IProgressMonitor monitor) {
        this.handleProjectRecordable(project, 3, monitor);
    }

    public void saving(ISaveContext saveContext) throws CoreException {
        this.handlerWorkspaceRecordable(saveContext, 2, null);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void doneSaving(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }
}

