/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.preference;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class PluginScope
implements IScopeContext {
    public static final String SCOPE = "plugin";
    private Plugin plugin;

    public PluginScope(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException();
        }
        this.plugin = plugin;
    }

    public IPath getLocation() {
        IPath path = ResourcesPlugin.getPlugin().getStateLocation();
        String pluginID = this.plugin.getBundle().getSymbolicName();
        path = path.removeLastSegments(1).append(pluginID);
        return path;
    }

    public String getName() {
        return SCOPE;
    }

    public IEclipsePreferences getNode(String qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        if (this.plugin == null) {
            return null;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String pluginID = this.plugin.getBundle().getSymbolicName();
        return (IEclipsePreferences)root.node(SCOPE).node(pluginID).node(qualifier);
    }
}

