/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.preference;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PluginPreferences
extends EclipsePreferences {
    private static Set loadedNodes = new HashSet();
    private String pluginID;
    private String qualifier;
    private IEclipsePreferences loadLevel;
    private int segmentCount;

    public PluginPreferences() {
        super(null, null);
    }

    private PluginPreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        String path = this.absolutePath();
        this.segmentCount = EclipsePreferences.getSegmentCount((String)path);
        if (this.segmentCount < 2) {
            return;
        }
        this.pluginID = EclipsePreferences.getSegment((String)path, (int)1);
        if (this.segmentCount > 2) {
            this.qualifier = EclipsePreferences.getSegment((String)path, (int)2);
        }
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new PluginPreferences(nodeParent, nodeName);
    }

    protected IPath getLocation() {
        if (this.pluginID == null || this.qualifier == null) {
            return null;
        }
        IPath path = ResourcesPlugin.getPlugin().getStateLocation();
        path = path.removeLastSegments(1).append(this.pluginID);
        return this.computeLocation(path, this.qualifier);
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.pluginID == null || this.qualifier == null) {
                return null;
            }
            PluginPreferences node = this;
            int i = 3;
            while (i < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }
}

