/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.seasar.kijimuna.core.util.ProjectUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class Element
implements IAdaptable,
Serializable {
    private Element root;
    private transient IProject project;
    private String projectName;
    private transient IStorage storage;
    private String fullPath;
    private String elementName;
    private int depth;
    private int startLine;
    private int startColumn;
    private Map attributes;
    private Element parent;
    private List children;
    private int endLine;
    private int endColumn;
    private String body;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Element(IProject project, IStorage storage, String elementName) {
        this.elementName = elementName;
        this.project = project;
        this.storage = storage;
        this.projectName = project.getName();
        this.fullPath = ProjectUtils.getPathString(storage);
        this.children = new ArrayList();
    }

    public Element getRootElement() {
        return this.root;
    }

    public void setRootElement(Element root) {
        this.root = root;
    }

    public String getElementName() {
        return this.elementName;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartLocation(int depth, int startLine, int startColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.depth = depth;
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public void setAttributes(Map properties) {
        this.attributes = properties;
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element parent) {
        this.parent = parent;
        parent.addChild(this);
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setEndLocation(int endLine, int endColumn) {
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public List getChildren() {
        return this.children;
    }

    public List getChildren(String elementName) {
        ArrayList<Element> list = new ArrayList<Element>();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            if (!child.getElementName().equals(elementName)) continue;
            list.add(child);
        }
        return list;
    }

    protected void addChild(Element child) {
        this.children.add(child);
    }

    public IProject getProject() {
        if (this.project == null && StringUtils.existValue(this.projectName)) {
            this.project = ProjectUtils.getProject(this.projectName);
        }
        return this.project;
    }

    public IStorage getStorage() {
        if (this.storage == null && StringUtils.existValue(this.fullPath)) {
            this.storage = ProjectUtils.getStorage(this.getProject(), this.fullPath);
        }
        return this.storage;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getProject();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getStorage();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.seasar.kijimuna.core.parser.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(adapter)) {
            return this;
        }
        return null;
    }
}

