/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.parser.ElementFactory;
import org.seasar.kijimuna.core.parser.IParseStopper;
import org.seasar.kijimuna.core.parser.StopParse;
import org.seasar.kijimuna.core.util.MarkerUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentHandler
extends DefaultHandler
implements ConstCore {
    private IProject project;
    private IStorage storage;
    private IParseStopper stopper;
    private IProgressMonitor monitor;
    private Stack stack = new Stack();
    private Locator locator;
    private Map dtdMap;
    private ElementFactory factory;
    private Element result;
    private String markerType;
    private int errorSeverity;
    private int warningSeverity;

    public DocumentHandler(ElementFactory factory) {
        this(factory, null, 3, 3);
    }

    public DocumentHandler(ElementFactory factory, String markerType, int errorSeverity, int warningSeverity) {
        this.setDocumentLocator(this.locator);
        this.dtdMap = new HashMap();
        this.factory = factory;
        this.markerType = markerType;
        this.errorSeverity = errorSeverity;
        this.warningSeverity = warningSeverity;
    }

    public void setStorage(IProject project, IStorage storage) {
        this.project = project;
        this.storage = storage;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setParseStopper(IParseStopper stopper) {
        this.stopper = stopper;
    }

    public void putDtdPath(String publicId, String path) {
        this.dtdMap.put(publicId, path);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String dtdPath;
        if (publicId != null && (dtdPath = (String)this.dtdMap.get(publicId)) != null) {
            try {
                return new InputSource(Kijimuna.getEntry(dtdPath).openStream());
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void startDocument() throws SAXException {
        this.stopTest();
        if (this.factory == null) {
            this.factory = new ElementFactory();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        this.stopTest();
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        int depth = this.stack.size() + 1;
        HashMap<String, String> property = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.getLength()) {
            property.put(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        Element element = this.factory.createElement(this.project, this.storage, qName);
        element.setStartLocation(depth, this.locator.getLineNumber(), this.locator.getColumnNumber());
        element.setAttributes(property);
        if (depth == 1) {
            this.result = element;
            element.setRootElement(element);
        } else {
            element.setRootElement(this.result);
            Element parent = (Element)this.stack.peek();
            element.setParent(parent);
        }
        this.stack.push(element);
    }

    public void characters(char[] buffer, int start, int length) {
        this.stopTest();
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        Element element = (Element)this.stack.peek();
        StringBuffer body = new StringBuffer();
        String old = element.getBody();
        if (old != null) {
            body.append(old);
        }
        body.append(new String(buffer, start, length));
        element.setBody(body.toString());
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.stopTest();
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        Element element = (Element)this.stack.pop();
        element.setEndLocation(this.locator.getLineNumber(), this.locator.getColumnNumber());
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.stopTest();
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        Kijimuna.reportException(exception);
        this.error(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.storage != null && this.storage instanceof IFile && this.markerType != null) {
            MarkerUtils.createMarker(this.markerType, "marker.severity.xml_error", this.errorSeverity, (IResource)((IFile)this.storage), exception.getLineNumber(), "[XML]" + exception.getMessage());
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.storage != null && this.storage instanceof IFile && this.markerType != null) {
            MarkerUtils.createMarker(this.markerType, "marker.severity.xml_warning", this.warningSeverity, (IResource)((IFile)this.storage), exception.getLineNumber(), "[XML]" + exception.getMessage());
        }
    }

    private void stopTest() throws StopParse {
        if (this.stopper != null && this.stopper.stopTest(this.locator)) {
            throw new StopParse();
        }
    }

    public Element getResult() {
        return this.result;
    }
}

