/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import java.util.List;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.model.MethodElement;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.util.ModelUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class ManualMethodInvoke
implements IValidation,
ConstCore {
    public void validation(Element element) {
        if (element instanceof MethodElement) {
            this.invoke((MethodElement)element);
        }
    }

    private void invoke(MethodElement method) {
        String methodName = method.getMethodName();
        List argList = method.getArgList();
        if (StringUtils.noneValue(methodName) || argList.size() == 0) {
            return;
        }
        IRtti component = ModelUtils.getComponentRtti(method);
        IRtti[] rttiArgs = ModelUtils.getMethodArgRttis(method);
        if (component != null && !component.hasMethod(methodName, rttiArgs)) {
            String display = ModelUtils.getMethodDisplay(component, methodName, rttiArgs, true);
            MarkerSetting.createDiconMarker("dicon.validation.ManualMethodInvoke.1", (Element)method, new Object[]{display});
        }
    }
}

