/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.util.StringUtils;

public class ComponentValidation
implements IValidation,
ConstCore {
    public void validation(Element element) {
        if (element instanceof ComponentElement) {
            ComponentElement component = (ComponentElement)element;
            this.checkError(component);
            this.validComponent(component);
        }
    }

    private void checkError(ComponentElement component) {
        if (component.hasError()) {
            MarkerSetting.createDiconMarker("dicon.validation.ComponentValidation.1", (Element)component, component.getErrorMessage());
        }
    }

    private void validComponent(ComponentElement component) {
        String el = component.getExpression();
        String className = component.getComponentClassName();
        String instance = component.getInstanceMode();
        if (StringUtils.noneValue(className) && StringUtils.noneValue(el) && !instance.equals("outer")) {
            MarkerSetting.createDiconMarker("dicon.validation.ComponentValidation.2", component);
        }
        if (StringUtils.existValue(className) && StringUtils.existValue(el)) {
            MarkerSetting.createDiconMarker("dicon.validation.ComponentValidation.3", component);
        }
    }
}

