/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import java.util.Iterator;
import java.util.List;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.model.ComponentHolderElement;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.util.StringUtils;

public class ComponentHolderValidation
implements IValidation,
ConstCore {
    public void validation(Element element) {
        if (element instanceof ComponentHolderElement) {
            ComponentHolderElement arg = (ComponentHolderElement)element;
            this.checkError(arg);
            this.validComponentHolder(arg);
        }
    }

    private void checkError(ComponentHolderElement componentHolder) {
        if (componentHolder.hasError()) {
            MarkerSetting.createDiconMarker("dicon.validation.ComponentHolderValidation.1", (Element)componentHolder, componentHolder.getErrorMessage());
        }
    }

    private void validComponentHolder(ComponentHolderElement componentHolder) {
        String el = componentHolder.getExpression();
        List children = componentHolder.getChildren();
        int size = children.size();
        if (StringUtils.existValue(el)) {
            if (size > 0) {
                Element element = (Element)children.get(size - 1);
                MarkerSetting.createDiconMarker("dicon.validation.ComponentHolderValidation.2", element);
            }
        } else if (size == 0) {
            MarkerSetting.createDiconMarker("dicon.validation.ComponentHolderValidation.3", componentHolder);
        }
        if (size > 1) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                MarkerSetting.createDiconMarker("dicon.validation.ComponentHolderValidation.4", element);
            }
        }
    }
}

