/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IComponentInfo;
import org.seasar.kijimuna.core.dicon.IComponentNotFound;
import org.seasar.kijimuna.core.dicon.ITooManyRegisted;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;
import org.seasar.kijimuna.core.util.ModelUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class AutoConstructorInvoke
implements IValidation,
ConstCore {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void validation(Element element) {
        if (element instanceof ComponentElement) {
            ComponentElement component = (ComponentElement)element;
            String el = component.getExpression();
            if (component.getArgList().size() == 0 && StringUtils.noneValue(el)) {
                String autoBinding = component.getAutoBindingMode();
                if (autoBinding.equals("auto") || autoBinding.equals("constructor")) {
                    this.autoAssembler(component);
                } else {
                    this.defaultAssembler(component);
                }
            }
        }
    }

    private void defaultAssembler(ComponentElement component) {
        IRtti rtti;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((rtti = (IRtti)component.getAdapter(clazz)) != null && !rtti.hasConstructor(new IRtti[0])) {
            MarkerSetting.createDiconMarker("dicon.validation.AutoConstructorInvoke.1", (Element)component, new Object[]{rtti.getQualifiedName()});
        }
    }

    private void reportInjection(ComponentElement component, IRtti[] suitableArgs, IRtti[] injectedArgs, String display) {
        int i = 0;
        while (i < injectedArgs.length) {
            if (injectedArgs[i] instanceof IComponentNotFound) {
                MarkerSetting.createDiconMarker("dicon.validation.AutoConstructorInvoke.3", (Element)component, new Object[]{display, new Integer(i + 1)});
            } else if (injectedArgs[i] instanceof ITooManyRegisted) {
                MarkerSetting.createDiconMarker("dicon.validation.AutoConstructorInvoke.5", (Element)component, new Object[]{display, new Integer(i + 1)});
            } else {
                MarkerSetting.createDiconMarker("dicon.validation.AutoConstructorInvoke.2", (Element)component, new Object[]{display, new Integer(i + 1), ModelUtils.getInjectedElementName(injectedArgs[i])});
            }
            ++i;
        }
    }

    private boolean checkCyclicReference(ComponentElement component, IRtti injectedArg, int num, String display) {
        if ("singleton".equals(component.getInstanceMode())) {
            ComponentElement injectedElement;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.model.ComponentElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (component.equals(injectedElement = (ComponentElement)injectedArg.getAdapter(clazz))) {
                MarkerSetting.createDiconMarker("dicon.validation.AutoConstructorInvoke.4", (Element)component, new Object[]{display, new Integer(num + 1)});
                return true;
            }
        }
        return false;
    }

    private void autoAssembler(ComponentElement component) {
        IComponentInfo info;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.seasar.kijimuna.core.dicon.IComponentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IComponentInfo)component.getAdapter(clazz)) != null) {
            IRttiMethod suitable = info.getAutoInjectedConstructor();
            if (suitable != null) {
                IRtti[] suitableArgs = suitable.getArgs();
                IRtti[] injectedArgs = suitable.getValues();
                if (injectedArgs != null) {
                    String display = ModelUtils.getMethodDisplay(suitable, true);
                    int i = 0;
                    while (i < suitableArgs.length) {
                        if (injectedArgs[i] != null) {
                            this.checkCyclicReference(component, injectedArgs[i], i, display);
                        }
                        ++i;
                    }
                    this.reportInjection(component, suitableArgs, injectedArgs, display);
                }
            } else {
                this.defaultAssembler(component);
            }
        }
    }
}

