/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.validation;

import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IAspectInfo;
import org.seasar.kijimuna.core.dicon.IPointcut;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.model.AspectElement;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;
import org.seasar.kijimuna.core.rtti.RttiClassNotFoundException;
import org.seasar.kijimuna.core.util.ModelUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class AspectValidation
implements IValidation,
ConstCore {
    private static IRtti interceptor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void validation(Element element) {
        if (element instanceof AspectElement) {
            AspectElement aspect = (AspectElement)element;
            this.validAspect(aspect);
            this.validAOP(aspect);
        }
    }

    private boolean hasClassName(AspectElement aspect) {
        ComponentElement parent = (ComponentElement)aspect.getParent();
        String className = parent.getComponentClassName();
        return StringUtils.existValue(className);
    }

    private IRtti getInterceptorRtti(AspectElement aspect) {
        if (interceptor == null) {
            interceptor = aspect.getRttiLoader().loadRtti("org.aopalliance.intercept.MethodInterceptor");
        }
        return interceptor;
    }

    private void validAspect(AspectElement aspect) {
        IRtti rtti;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((rtti = (IRtti)aspect.getAdapter(clazz)) != null) {
            try {
                IRtti interceptor = this.getInterceptorRtti(aspect);
                if (!interceptor.isAssignableFrom(rtti)) {
                    MarkerSetting.createDiconMarker("dicon.validation.AspectValidation.1", aspect);
                }
            }
            catch (RttiClassNotFoundException rttiClassNotFoundException) {
                MarkerSetting.createDiconMarker("dicon.validation.AspectValidation.2", aspect);
            }
        }
        if (!this.hasClassName(aspect)) {
            MarkerSetting.createDiconMarker("dicon.validation.AspectValidation.3", aspect);
        } else if (aspect.hasError()) {
            MarkerSetting.createDiconMarker("dicon.validation.AspectValidation.4", (Element)aspect, aspect.getErrorMessage());
        }
    }

    private void validAOP(AspectElement aspect) {
        IAspectInfo info;
        IRtti rtti = ModelUtils.getComponentRtti(aspect);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.IAspectInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IAspectInfo)aspect.getAdapter(clazz)) != null) {
            IPointcut[] pointcuts = info.getPointcuts();
            int i = 0;
            while (i < pointcuts.length) {
                if (pointcuts[i].hasError()) {
                    MarkerSetting.createDiconMarker("dicon.validation.AspectValidation.5", (Element)aspect, new Object[]{pointcuts[i].getErrorMessage()});
                } else if (this.hasClassName(aspect)) {
                    IRttiMethod[] methods = pointcuts[i].getApplyMethods();
                    int k = 0;
                    while (k < methods.length) {
                        if (methods[k].isFinal() || methods[k].isStatic()) {
                            String display = ModelUtils.getMethodDisplay(methods[k], true);
                            String errorID = methods[k].isFinal() ? "dicon.validation.AspectValidation.6" : "dicon.validation.AspectValidation.7";
                            MarkerSetting.createDiconMarker(errorID, (Element)aspect, new Object[]{display});
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        if (rtti != null && rtti.isFinal()) {
            MarkerSetting.createDiconMarker("dicon.validation.AspectValidation.8", (Element)aspect, new Object[]{rtti.getQualifiedName()});
        }
    }
}

