/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.tools;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.seasar.kijimuna.core.dicon.IPointcut;
import org.seasar.kijimuna.core.dicon.model.AspectElement;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;
import org.seasar.kijimuna.core.util.ModelUtils;

public class Pointcut
implements IPointcut {
    private AspectElement aspect;
    private String regexp;
    private String message;
    private Pattern pattern;
    private transient IRttiMethod[] methods;

    public Pointcut(AspectElement aspect, String regexp) {
        this.aspect = aspect;
        this.regexp = regexp;
        this.getPattern();
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(this.regexp);
            }
            catch (PatternSyntaxException e) {
                this.message = e.getMessage();
            }
        }
        return this.pattern;
    }

    public IRttiMethod[] getApplyMethods() {
        if (this.methods == null) {
            IRtti rtti;
            this.methods = new IRttiMethod[0];
            Pattern p = this.getPattern();
            if (p != null && (rtti = ModelUtils.getComponentRtti(this.aspect)) != null) {
                this.methods = rtti.getMethods(p);
            }
        }
        return this.methods;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public int compareTo(Object test) {
        if (test instanceof IPointcut) {
            IPointcut pointcut = (IPointcut)test;
            return this.getRegexp().compareTo(pointcut.getRegexp());
        }
        return 0;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public boolean hasError() {
        return this.message != null;
    }
}

