/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.model;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IComponentKey;
import org.seasar.kijimuna.core.dicon.IMethodInfo;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.dicon.model.DiconElement;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;
import org.seasar.kijimuna.core.util.StringUtils;

public class MethodElement
extends DiconElement
implements ConstCore {
    private IMethodInfo info;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MethodElement(IProject project, IStorage storage, String elementName) {
        super(project, storage, elementName);
    }

    public String getMethodName() {
        return this.getAttribute("name");
    }

    public List getArgList() {
        return this.getChildren("arg");
    }

    public boolean isOGNL() {
        return StringUtils.noneValue(this.getMethodName());
    }

    public String getDisplayName() {
        StringBuffer buffer = new StringBuffer();
        String method = this.getMethodName();
        if (this.isOGNL()) {
            String expression = this.getExpression();
            if (StringUtils.existValue(expression)) {
                buffer.append("[").append(expression).append("]");
            } else {
                buffer.append("[...]");
            }
        } else {
            buffer.append(method);
        }
        return buffer.toString();
    }

    private IRttiMethod getSuitableMethod(IRtti component, String methodName) {
        if (component != null) {
            IRttiMethod[] methods = component.getMethods(Pattern.compile(methodName));
            IRttiMethod suitable = null;
            int size = -1;
            int i = 0;
            while (i < methods.length) {
                IRtti[] rttiArgs = methods[i].getArgs();
                if (size < rttiArgs.length) {
                    boolean flag = true;
                    int k = 0;
                    while (k < rttiArgs.length) {
                        if (!rttiArgs[k].isInterface()) {
                            flag = false;
                            break;
                        }
                        ++k;
                    }
                    if (flag) {
                        size = rttiArgs.length;
                        suitable = methods[i];
                    }
                }
                ++i;
            }
            return suitable;
        }
        return null;
    }

    public IRttiMethod findAutoInjectedMethod() {
        ComponentElement component;
        String methodName = this.getMethodName();
        if (StringUtils.existValue(methodName) && StringUtils.existValue((component = (ComponentElement)this.getParent()).getComponentClassName())) {
            IRttiMethod suitable;
            IRtti rtti;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rtti = (IRtti)component.getAdapter(clazz)) != null && (suitable = this.getSuitableMethod(rtti, this.getMethodName())) != null) {
                IRtti[] suitableArgs = suitable.getArgs();
                IRtti[] injectedArgs = new IRtti[suitableArgs.length];
                int i = 0;
                while (i < suitableArgs.length) {
                    IRtti inject;
                    ContainerElement container = this.getContainerElement();
                    IComponentKey key = container.createComponentKey(suitableArgs[i]);
                    injectedArgs[i] = inject = container.getComponent(key);
                    ++i;
                }
                suitable.setValues(injectedArgs);
                return suitable;
            }
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.IMethodInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            if (this.info == null) {
                this.info = new IMethodInfo(){

                    public IRttiMethod getAutoInjectedMethod() {
                        return MethodElement.this.findAutoInjectedMethod();
                    }
                };
            }
            return this.info;
        }
        return super.getAdapter(adapter);
    }
}

