/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.dicon.IComponentInfo;
import org.seasar.kijimuna.core.dicon.IComponentKey;
import org.seasar.kijimuna.core.dicon.ITooManyRegisted;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.model.DiconElement;
import org.seasar.kijimuna.core.dicon.model.IncludeElement;
import org.seasar.kijimuna.core.dicon.model.TooManyRegistrationHolder;
import org.seasar.kijimuna.core.dicon.tools.ComponentKeyRtti;
import org.seasar.kijimuna.core.dicon.tools.ComponentKeyString;
import org.seasar.kijimuna.core.dicon.tools.ComponentNotFoundRtti;
import org.seasar.kijimuna.core.dicon.tools.ContainerRtti;
import org.seasar.kijimuna.core.dicon.tools.InjectedRtti;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;
import org.seasar.kijimuna.core.rtti.IRttiProperty;
import org.seasar.kijimuna.core.rtti.RttiClassNotFoundException;
import org.seasar.kijimuna.core.util.ProjectUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class ContainerElement
extends DiconElement
implements ConstCore,
Comparable {
    private static IRtti s2ContainerRtti;
    private Map componentDefMap = new HashMap();
    private Map componentKeyMap = new HashMap();
    private Set containerKeySet = new TreeSet();
    private IComponentInfo info;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ContainerElement(IProject project, IStorage storage) {
        super(project, storage, "components");
        IComponentKey key = this.createComponentKey("container");
        this.componentDefMap.put(key, this);
        this.containerKeySet.add(key);
        IRtti rtti = this.getS2ContainerRtti();
        if (rtti != null) {
            IComponentKey interfaceKey = this.createComponentKey(rtti);
            this.componentDefMap.put(interfaceKey, this);
            this.containerKeySet.add(interfaceKey);
        }
    }

    private IRtti getS2ContainerRtti() {
        if (s2ContainerRtti == null) {
            try {
                s2ContainerRtti = this.getRttiLoader().loadRtti("org.seasar.framework.container.S2Container");
            }
            catch (RttiClassNotFoundException rttiClassNotFoundException) {}
        }
        return s2ContainerRtti;
    }

    public void setAttributes(Map properties) {
        super.setAttributes(properties);
        String namespace = this.getNamespace();
        if (StringUtils.existValue(namespace)) {
            IComponentKey key = this.createComponentKey(namespace);
            this.componentDefMap.put(key, this);
            this.containerKeySet.add(key);
        }
    }

    protected void addChild(Element child) {
        super.addChild(child);
        if (child instanceof ComponentElement) {
            this.registComponentElement((ComponentElement)child);
        }
    }

    public List getComponentList() {
        return this.getChildren("component");
    }

    public List getIncludeList() {
        return this.getChildren("include");
    }

    public String getNamespace() {
        return super.getAttribute("namespace");
    }

    public String getPath() {
        IStorage storage;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((storage = (IStorage)this.getAdapter(clazz)) != null) {
            return ProjectUtils.getResourceLoaderPath(storage);
        }
        return null;
    }

    public IComponentKey createComponentKey(Object key) {
        String keyString = key.toString();
        IComponentKey ret = (IComponentKey)this.componentKeyMap.get(keyString);
        if (ret == null) {
            ret = key instanceof IRtti ? new ComponentKeyRtti((IRtti)key) : new ComponentKeyString(keyString);
            this.componentKeyMap.put(keyString, ret);
        }
        return ret;
    }

    public void registComponentElement(ComponentElement component) {
        String instance = component.getInstanceMode();
        if (!instance.equals("outer")) {
            IComponentInfo keyInfo;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.IComponentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((keyInfo = (IComponentInfo)component.getAdapter(clazz)) != null) {
                IComponentKey[] keys = keyInfo.getComponentKeys();
                int i = 0;
                while (i < keys.length) {
                    this.registComponentElementByKey(keys[i], component);
                    ++i;
                }
            }
        }
    }

    private void registComponentElementByKey(IComponentKey key, ComponentElement component) {
        if (key != null) {
            DiconElement registed = (DiconElement)this.componentDefMap.get(key);
            if (registed == null) {
                this.componentDefMap.put(key, component);
            } else {
                key.makeTooMany();
                if (registed instanceof TooManyRegistrationHolder) {
                    ((TooManyRegistrationHolder)registed).addComponentElement(component);
                } else {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.core.resources.IProject");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IProject project = (IProject)this.getAdapter(clazz);
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IStorage storage = (IStorage)this.getAdapter(clazz2);
                    if (project != null && storage != null) {
                        TooManyRegistrationHolder holder = new TooManyRegistrationHolder(project, storage, key);
                        holder.addComponentElement(registed);
                        holder.addComponentElement(component);
                        this.componentDefMap.put(key, holder);
                    }
                }
            }
        }
    }

    private DiconElement findDefinition(IComponentKey componentKey) {
        DiconElement element = (DiconElement)this.componentDefMap.get(componentKey);
        if (element != null) {
            return element;
        }
        Iterator it = this.getIncludeList().iterator();
        while (it.hasNext()) {
            IncludeElement incl = (IncludeElement)it.next();
            ContainerElement childContainer = incl.getChildContainer();
            element = childContainer.findDefinition(componentKey);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public IRtti getComponent(IComponentKey componentKey) {
        DiconElement element = this.findDefinition(componentKey);
        if (element instanceof ContainerElement) {
            ContainerElement container = (ContainerElement)element;
            return new ContainerRtti(this.getS2ContainerRtti(), container, componentKey);
        }
        if (element instanceof ComponentElement) {
            IRtti rtti;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rtti = (IRtti)element.getAdapter(clazz)) != null) {
                if (rtti instanceof ITooManyRegisted) {
                    return rtti;
                }
                ComponentElement component = (ComponentElement)element;
                return new InjectedRtti(rtti, component, componentKey);
            }
        }
        return new ComponentNotFoundRtti(componentKey);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getS2ContainerRtti();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.IComponentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            if (this.info == null) {
                this.info = new IComponentInfo(){

                    public IComponentKey[] getComponentKeys() {
                        return ContainerElement.this.containerKeySet.toArray(new IComponentKey[ContainerElement.this.containerKeySet.size()]);
                    }

                    public IRttiMethod getAutoInjectedConstructor() {
                        return null;
                    }

                    public IRttiProperty[] getAutoInjectedProperties() {
                        return new IRttiProperty[0];
                    }
                };
            }
            return this.info;
        }
        return super.getAdapter(adapter);
    }

    public boolean isOGNL() {
        return false;
    }

    public String getDisplayName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath());
        String namespace = this.getNamespace();
        if (StringUtils.existValue(namespace)) {
            buffer.append("<").append(namespace).append(">");
        }
        return buffer.toString();
    }

    public int compareTo(Object test) {
        if (test instanceof ContainerElement) {
            ContainerElement container = (ContainerElement)test;
            return this.getPath().compareTo(container.getPath());
        }
        return 0;
    }
}

