/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.IComponentInfo;
import org.seasar.kijimuna.core.dicon.IComponentKey;
import org.seasar.kijimuna.core.dicon.model.AbstractExpressionElement;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.rtti.IRttiMethod;
import org.seasar.kijimuna.core.rtti.IRttiProperty;
import org.seasar.kijimuna.core.util.ModelUtils;
import org.seasar.kijimuna.core.util.StringUtils;

public class ComponentElement
extends AbstractExpressionElement
implements ConstCore {
    private Set componentKeySet;
    private IComponentInfo info;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ComponentElement(IProject project, IStorage storage) {
        super(project, storage, "component");
    }

    protected IRtti getNonExpressionValue() throws Exception {
        String className = this.getComponentClassName();
        if (StringUtils.existValue(className)) {
            return this.getRttiLoader().loadRtti(className);
        }
        return null;
    }

    public String getComponentName() {
        return this.getAttribute("name");
    }

    public String getComponentClassName() {
        return this.getAttribute("class");
    }

    public String getAutoBindingMode() {
        String autoBinding = this.getAttribute("autoBinding");
        if (StringUtils.noneValue(autoBinding)) {
            autoBinding = "auto";
        }
        return autoBinding;
    }

    public String getInstanceMode() {
        String instance = this.getAttribute("instance");
        if (instance == null) {
            instance = "singleton";
        }
        return instance;
    }

    private Set createKeys() {
        if (this.componentKeySet == null || !this.isLocking()) {
            String instance;
            ContainerElement container = this.getContainerElement();
            this.componentKeySet = new TreeSet();
            String componentName = this.getComponentName();
            if (StringUtils.existValue(componentName)) {
                IComponentKey nameKey = container.createComponentKey(componentName);
                this.componentKeySet.add(nameKey);
            }
            if (StringUtils.existValue(this.getComponentClassName()) && !"outer".equals(instance = this.getInstanceMode())) {
                this.setLocking(true);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IRtti rtti = (IRtti)this.getAdapter(clazz);
                this.setLocking(false);
                if (rtti != null) {
                    if (rtti.isInterface()) {
                        IComponentKey thisKey = container.createComponentKey(rtti);
                        this.componentKeySet.add(thisKey);
                    }
                    do {
                        IRtti[] interfaces = rtti.getInterfaces();
                        int i = 0;
                        while (i < interfaces.length) {
                            IComponentKey interfaceKey = container.createComponentKey(interfaces[i]);
                            this.componentKeySet.add(interfaceKey);
                            ++i;
                        }
                    } while ((rtti = rtti.getSuperClass()) != null);
                }
            }
        }
        return this.componentKeySet;
    }

    public List getArgList() {
        return this.getChildren("arg");
    }

    public List getAspectList() {
        return this.getChildren("aspect");
    }

    public List getPropertyList() {
        return this.getChildren("property");
    }

    public List getInitMethodList() {
        return this.getChildren("initMethod");
    }

    public List getDestroyMethodList() {
        return this.getChildren("destroyMethod");
    }

    private boolean isOuterInjection() {
        return "outer".equals(this.getInstanceMode());
    }

    private IRttiMethod getSuitableConstructor(IRtti rtti) {
        int size = -1;
        IRttiMethod suitable = null;
        IRttiMethod[] constructors = rtti.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            IRtti[] rttiArgs = constructors[i].getArgs();
            if (rttiArgs.length == 0) {
                return null;
            }
            if (size < rttiArgs.length) {
                boolean flag = true;
                int k = 0;
                while (k < rttiArgs.length) {
                    if (!rttiArgs[k].isInterface()) {
                        flag = false;
                        break;
                    }
                    ++k;
                }
                if (flag) {
                    size = rttiArgs.length;
                    suitable = constructors[i];
                }
            }
            ++i;
        }
        return suitable;
    }

    private IRttiMethod findAutoInjectedConstructor() {
        String autoBinding;
        String el = this.getExpression();
        if (this.getArgList().size() == 0 && StringUtils.noneValue(el) && ((autoBinding = this.getAutoBindingMode()).equals("auto") || autoBinding.equals("constructor"))) {
            IRttiMethod suitable;
            IRtti rtti;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rtti = (IRtti)this.getAdapter(clazz)) != null && (suitable = this.getSuitableConstructor(rtti)) != null) {
                IRtti[] suitableArgs = suitable.getArgs();
                IRtti[] injectedArgs = new IRtti[suitableArgs.length];
                int i = 0;
                while (i < suitableArgs.length) {
                    ContainerElement container = this.getContainerElement();
                    IComponentKey key = container.createComponentKey(suitableArgs[i]);
                    injectedArgs[i] = container.getComponent(key);
                    ++i;
                }
                suitable.setValues(injectedArgs);
                return suitable;
            }
        }
        return null;
    }

    private IRttiProperty[] autoInjectedProperties() {
        String autoBinding = this.getAutoBindingMode();
        if (autoBinding.equals("auto") || autoBinding.equals("property")) {
            IRtti rtti;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rtti = (IRtti)this.getAdapter(clazz)) != null) {
                ArrayList<IRttiProperty> list = new ArrayList<IRttiProperty>();
                IRttiProperty[] props = rtti.getSetterProperties();
                int i = 0;
                while (i < props.length) {
                    String name = props[i].getName();
                    if (props[i].getType().isInterface() && !ModelUtils.hasPropertyElement(this, name)) {
                        ContainerElement container = this.getContainerElement();
                        IComponentKey key = container.createComponentKey(props[i].getType());
                        IRtti inject = container.getComponent(key);
                        props[i].setValue(inject);
                        list.add(props[i]);
                    }
                    ++i;
                }
                return list.toArray(new IRttiProperty[list.size()]);
            }
        }
        return new IRttiProperty[0];
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.seasar.kijimuna.core.dicon.IComponentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            if (this.info == null) {
                this.info = new IComponentInfo(){

                    public IComponentKey[] getComponentKeys() {
                        if (ComponentElement.this.getDepth() == 2) {
                            Set keys = ComponentElement.this.createKeys();
                            return keys.toArray(new IComponentKey[keys.size()]);
                        }
                        return new IComponentKey[0];
                    }

                    public IRttiMethod getAutoInjectedConstructor() {
                        return ComponentElement.this.findAutoInjectedConstructor();
                    }

                    public IRttiProperty[] getAutoInjectedProperties() {
                        return ComponentElement.this.autoInjectedProperties();
                    }
                };
            }
            return this.info;
        }
        return super.getAdapter(adapter);
    }

    public boolean isOGNL() {
        if (this.isOuterInjection()) {
            return false;
        }
        if (StringUtils.noneValue(this.getComponentClassName())) {
            Object rtti;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rtti = this.getAdapter(clazz)) != null) {
                ComponentElement component;
                IAdaptable iAdaptable = (IAdaptable)rtti;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.seasar.kijimuna.core.dicon.model.ComponentElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((component = (ComponentElement)iAdaptable.getAdapter((Class)clazz2)) != null) {
                    return component.isOGNL();
                }
            }
            return true;
        }
        return super.isOGNL();
    }

    public String getDisplayName() {
        StringBuffer buffer = new StringBuffer();
        if (this.isOuterInjection() && StringUtils.noneValue(this.getComponentClassName())) {
            buffer.append(Kijimuna.getResourceString("dicon.model.ComponentElement.1"));
        } else {
            buffer.append(super.getDisplayName());
        }
        String name = this.getComponentName();
        if (StringUtils.existValue(name)) {
            buffer.append("<").append(name).append(">");
        }
        return buffer.toString();
    }
}

