/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.DiconNature;
import org.seasar.kijimuna.core.dicon.IValidation;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.dicon.model.DiconElement;
import org.seasar.kijimuna.core.dicon.validation.DiconValidationFactory;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.project.AbstractProcessor;
import org.seasar.kijimuna.core.project.IFileProcessor;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.MarkerUtils;

public class DiconValidator
extends AbstractProcessor
implements ConstCore {
    private static IValidation[] validations = DiconValidationFactory.createValidation();
    static /* synthetic */ Class class$0;

    public String getNatureID() {
        return "org.seasar.kijimuna.core.nature";
    }

    public void handleFileAdded(IFile addedFile, boolean fullBuild, IProgressMonitor monitor) {
        if (!fullBuild && FileUtils.isJavaFile((IStorage)addedFile)) {
            this.fullValidate(addedFile.getProject(), monitor);
        } else {
            this.process(addedFile.getProject(), (IStorage)addedFile, monitor);
        }
    }

    public void handleFileRemoved(IFile removedFile, IProgressMonitor monitor) {
        this.relatedValidate(removedFile, monitor);
    }

    public void handleFileChanged(IFile changedFile, IProgressMonitor monitor) {
        this.process(changedFile.getProject(), (IStorage)changedFile, monitor);
        this.relatedValidate(changedFile, monitor);
    }

    public void handlePrepareFullProcess(IProject project, IProgressMonitor monitor) {
    }

    public void handleClassPassChanged(IProject project, IProgressMonitor monitor) {
        this.fullValidate(project, monitor);
    }

    public IFileProcessor getFileBuilder() {
        return this;
    }

    private void fullValidate(IProject project, IProgressMonitor monitor) {
        DiconNature nature = DiconNature.getInstance(project);
        if (nature != null) {
            ContainerElement[] containers = nature.getModel().getContainers(monitor);
            int i = 0;
            while (i < containers.length) {
                ContainerElement containerElement = containers[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IFile file = (IFile)containerElement.getAdapter(clazz);
                MarkerUtils.deleteMarker((IResource)file, "org.seasar.kijimuna.core.marker.diconvalidation");
                this.validElement(containers[i], monitor);
                ++i;
            }
        }
    }

    public void process(IProject project, IStorage storage, IProgressMonitor monitor) {
        if (FileUtils.isDiconFile(storage)) {
            ContainerElement container;
            DiconNature nature;
            if (storage instanceof IFile) {
                MarkerUtils.deleteMarker((IResource)((IFile)storage), "org.seasar.kijimuna.core.marker.diconvalidation");
            }
            if ((nature = DiconNature.getInstance(project)) != null && (container = nature.getModel().getContainer(storage, monitor)) != null) {
                this.validElement(container, monitor);
            }
        }
    }

    public void handleFinish(IProject project, IProgressMonitor monitor) {
    }

    private void validElement(Element element, IProgressMonitor monitor) {
        if (element instanceof DiconElement) {
            ((DiconElement)element).setLocking(true);
        }
        int i = 0;
        while (i < validations.length) {
            try {
                validations[i].validation(element);
            }
            catch (Exception e) {
                Kijimuna.reportException(e);
            }
            ++i;
        }
        List children = element.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            this.validElement(child, monitor);
        }
        if (element instanceof DiconElement) {
            ((DiconElement)element).setLocking(false);
        }
    }

    private void relatedValidate(IFile file, IProgressMonitor monitor) {
        DiconNature nature;
        if ((FileUtils.isDiconFile((IStorage)file) || FileUtils.isJavaFile((IStorage)file)) && (nature = DiconNature.getInstance(file.getProject())) != null) {
            IFile[] relateds = nature.getModel().getRelatedFiles((IStorage)file, true);
            int i = 0;
            while (i < relateds.length) {
                this.process(file.getProject(), (IStorage)relateds[i], monitor);
                ++i;
            }
        }
    }
}

