/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.ModelManager;
import org.seasar.kijimuna.core.project.AbstractNature;
import org.seasar.kijimuna.core.project.IProjectRecordable;
import org.seasar.kijimuna.core.rtti.IRttiCache;
import org.seasar.kijimuna.core.rtti.RttiLoader;
import org.seasar.kijimuna.core.util.MarkerUtils;
import org.seasar.kijimuna.core.util.ProjectUtils;

public class DiconNature
extends AbstractNature
implements IProjectRecordable,
ConstCore {
    private static final String[] BUILDERS = new String[]{"org.seasar.kijimuna.core.builder", "org.seasar.kijimuna.core.validator"};
    private ModelManager model = new ModelManager();
    private RttiLoader rootLoader;

    public static DiconNature getInstance(IProject project) {
        if (project != null) {
            try {
                IProjectNature nature = project.getNature("org.seasar.kijimuna.core.nature");
                if (nature instanceof DiconNature) {
                    return (DiconNature)nature;
                }
            }
            catch (CoreException e) {
                Kijimuna.reportException((Exception)((Object)e));
            }
        }
        return null;
    }

    public void setProject(IProject project) {
        super.setProject(project);
        this.model.setProjectName(project.getName());
    }

    public IRttiCache getRttiCache() {
        return this.getRttiLoader().getRttiCache();
    }

    public ModelManager getModel() {
        return this.model;
    }

    public void configure() throws CoreException {
        ProjectUtils.addBuilders(this.getProject(), BUILDERS);
    }

    public void deconfigure() throws CoreException {
        ProjectUtils.removeBuilders(this.getProject(), BUILDERS);
        MarkerUtils.deleteMarker((IResource)this.getProject(), "org.seasar.kijimuna.core.marker");
        Kijimuna.getProjectRecorder().cleanup(this.getProject(), null);
    }

    public RttiLoader getRttiLoader() {
        if (this.rootLoader == null) {
            this.rootLoader = new RttiLoader(this.getProject().getName(), true);
        }
        return this.rootLoader;
    }

    public void initProjectRecords(IProgressMonitor monitor) {
        this.model.init(monitor);
    }

    public boolean restoreProjectRecords(IPath recorderPath, IProgressMonitor monitor) {
        boolean success;
        block7: {
            File file = recorderPath.append(this.getProject().getName()).addFileExtension("model").toFile();
            success = false;
            if (file.exists()) {
                try {
                    ObjectInputStream stream = new ObjectInputStream(new FileInputStream(file));
                    Object obj = stream.readObject();
                    if (obj instanceof ModelManager) {
                        ModelManager modelManager = this.model;
                        synchronized (modelManager) {
                            this.model = (ModelManager)obj;
                            this.model.afterRestoring();
                        }
                        success = true;
                        break block7;
                    }
                    Kijimuna.reportInfo(Kijimuna.getResourceString("dicon.DiconNature.1"));
                }
                catch (Exception e) {
                    Kijimuna.reportException(e);
                }
            }
        }
        return success;
    }

    public boolean saveProjectRecords(IPath recorderPath, IProgressMonitor monitor) {
        boolean success = false;
        if (this.model.isDirty()) {
            File file = recorderPath.append(this.getProject().getName()).addFileExtension("model").toFile();
            try {
                ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(file));
                this.model.prepareStoraging();
                stream.writeObject(this.model);
                success = true;
            }
            catch (Exception e) {
                Kijimuna.reportException(e);
            }
        }
        return success;
    }

    public void customProcess(int type, IPath recorderPath, IProgressMonitor monitor) {
        if (type == 3) {
            this.model.validate(monitor);
        }
    }
}

