/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core.dicon;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.DiconNature;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.dicon.tools.DiconElementFactory;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.parser.DocumentHandler;
import org.seasar.kijimuna.core.parser.DocumentParser;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.project.AbstractProcessor;
import org.seasar.kijimuna.core.project.IFileProcessor;
import org.seasar.kijimuna.core.project.ResourceVisitor;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.MarkerUtils;

public class DiconBuilder
extends AbstractProcessor
implements ConstCore {
    private DocumentParser parser = new DocumentParser();

    public String getNatureID() {
        return "org.seasar.kijimuna.core.nature";
    }

    public IFileProcessor getFileBuilder() {
        return this;
    }

    public void handlePrepareFullProcess(IProject project, IProgressMonitor monitor) {
        DiconNature nature;
        if (monitor != null) {
            monitor.beginTask(project.getName(), -1);
        }
        if ((nature = DiconNature.getInstance(project)) != null) {
            nature.getModel().clearContainer();
            nature.getRttiCache().clearRttiCache();
        }
    }

    public void handleFileAdded(IFile addedFile, boolean fullBuild, IProgressMonitor monitor) {
        this.process(addedFile.getProject(), (IStorage)addedFile, monitor);
    }

    public void handleFileChanged(IFile changedFile, IProgressMonitor monitor) {
        this.removeContainer(changedFile, monitor);
        this.process(changedFile.getProject(), (IStorage)changedFile, monitor);
    }

    public void handleFileRemoved(IFile removedFile, IProgressMonitor monitor) {
        if (FileUtils.isJavaFile((IStorage)removedFile)) {
            DiconNature nature = DiconNature.getInstance(removedFile.getProject());
            if (nature != null) {
                nature.getRttiCache().removeRttiFromCache((IStorage)removedFile);
            }
        } else {
            this.removeContainer(removedFile, monitor);
        }
    }

    public void handleClassPassChanged(IProject project, IProgressMonitor monitor) {
        DiconNature nature = DiconNature.getInstance(project);
        if (nature != null) {
            nature.getRttiCache().clearRttiCache();
        }
    }

    public void processProject(IProject project, IProgressMonitor monitor) {
        if (project != null) {
            try {
                project.accept((IResourceVisitor)new ResourceVisitor(this.getNatureID(), this, monitor));
            }
            catch (CoreException e) {
                Kijimuna.reportException((Exception)((Object)e));
            }
        }
    }

    public void process(IProject project, IStorage storage, IProgressMonitor monitor) {
        DiconNature nature;
        String fileExt = storage.getFullPath().getFileExtension();
        if (!"dicon".equalsIgnoreCase(fileExt)) {
            return;
        }
        if (monitor != null) {
            monitor.beginTask(storage.getName(), -1);
        }
        if (storage instanceof IFile) {
            MarkerUtils.deleteMarker((IResource)((IFile)storage), "org.seasar.kijimuna.core.marker");
        }
        if ((nature = DiconNature.getInstance(project)) != null) {
            if (monitor != null) {
                monitor.subTask(Kijimuna.getResourceString("dicon.DiconBuilder.1", new Object[]{storage.getName()}));
            }
            int errorSeverity = MarkerSetting.getDiconMarkerPreference(project, 0, false);
            int warningSeverity = MarkerSetting.getDiconMarkerPreference(project, 1, false);
            DocumentHandler handler = new DocumentHandler(new DiconElementFactory(), "org.seasar.kijimuna.core.marker.diconxml", errorSeverity, warningSeverity);
            handler.putDtdPath("-//SEASAR//DTD S2Container//EN", "/components.dtd");
            Element result = this.parser.parse(project, storage, monitor, handler);
            if (result != null && result instanceof ContainerElement) {
                ContainerElement container = (ContainerElement)result;
                nature.getModel().addContainerAndRelatedFile(container, null);
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public void handleFinish(IProject project, IProgressMonitor monitor) {
        DiconNature nature = DiconNature.getInstance(project);
        if (nature != null) {
            nature.getModel().fireRecordChanged();
        }
    }

    private void removeContainer(IFile file, IProgressMonitor monitor) {
        if (FileUtils.isDiconFile((IStorage)file)) {
            DiconNature nature;
            if (monitor != null) {
                monitor.beginTask(file.getName(), -1);
            }
            if ((nature = DiconNature.getInstance(file.getProject())) != null) {
                nature.getModel().removeContainer((IStorage)file);
            }
        }
    }
}

