/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class MessageManager {
    private Plugin plugin;
    private String resourceBaseName;
    private String pluginID;
    private ResourceBundle bundle;

    public MessageManager(Plugin plugin, String resourceBaseName) {
        this.plugin = plugin;
        this.resourceBaseName = resourceBaseName;
    }

    public void reportInfo(String message) {
        try {
            Status status = new Status(1, this.pluginID, 0, message, null);
            this.plugin.getLog().log((IStatus)status);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void reportException(Exception e) {
        try {
            Object status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, this.pluginID, 0, e.getMessage(), (Throwable)e);
            this.plugin.getLog().log(status);
        }
        catch (RuntimeException runtimeException) {}
    }

    public String getResourceString(String key) {
        try {
            if (this.bundle == null) {
                this.bundle = ResourceBundle.getBundle(this.resourceBaseName, Locale.getDefault(), this.plugin.getClass().getClassLoader());
            }
            return this.bundle.getString(key);
        }
        catch (Exception exception) {
            return "!" + key + "!";
        }
    }

    public String getResourceString(String key, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        return MessageFormat.format(this.getResourceString(key), args);
    }
}

