/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.core;

import java.net.URL;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.MessageManager;
import org.seasar.kijimuna.core.preference.IPreferences;
import org.seasar.kijimuna.core.preference.KijimunaPreferences;
import org.seasar.kijimuna.core.project.ProjectRecorder;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.MarkerUtils;

public class Kijimuna
extends Plugin
implements ConstCore {
    private static Kijimuna kijimuna;
    private static IPreferences preferences;
    private ProjectRecorder recorder;
    private MessageManager messageManager;

    public static Kijimuna getInstance() {
        return kijimuna;
    }

    public static void reportInfo(String message) {
        Kijimuna.kijimuna.messageManager.reportInfo(message);
    }

    public static void reportException(Exception e) {
        Kijimuna.kijimuna.messageManager.reportException(e);
    }

    public static String getResourceString(String key) {
        return Kijimuna.kijimuna.messageManager.getResourceString(key);
    }

    public static String getResourceString(String key, Object[] args) {
        return Kijimuna.kijimuna.messageManager.getResourceString(key, args);
    }

    public static URL getEntry(String path) {
        return kijimuna.getBundle().getEntry(path);
    }

    public static ProjectRecorder getProjectRecorder() {
        return Kijimuna.kijimuna.recorder;
    }

    public static String getVersion() {
        return kijimuna.getBundle().getHeaders().get("Bundle-Version").toString();
    }

    public static IPreferences getPreferences() {
        String version;
        if (preferences == null && !(version = (preferences = new KijimunaPreferences()).get("org.seasar.kijimuna.core.version")).equals(Kijimuna.getVersion())) {
            preferences.clear();
            preferences.put("org.seasar.kijimuna.core.version", Kijimuna.getVersion());
            Kijimuna.initPluginData();
        }
        return preferences;
    }

    private static void initPluginData() {
        MarkerUtils.removeAllMarker("org.seasar.kijimuna.core.marker");
        FileUtils.deleteAllFiles(kijimuna.getStateLocation());
    }

    public Kijimuna() {
        kijimuna = this;
        this.messageManager = new MessageManager(this, "org.seasar.kijimuna.core.resources");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Kijimuna.getPreferences();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.recorder = new ProjectRecorder(this);
        this.recorder.inithialize(null);
        workspace.addSaveParticipant((Plugin)this, (ISaveParticipant)this.recorder);
    }

    public void stop(BundleContext context) throws Exception {
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences pref = scope.getNode("org.seasar.kijimuna.core");
        pref.flush();
        Preferences pluginPref = Platform.getPreferencesService().getRootNode().node("plugin");
        pluginPref.flush();
        super.stop(context);
    }
}

