/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.seasar.kijimuna.core.dicon.model.ComponentElement;
import org.seasar.kijimuna.core.dicon.model.ContainerElement;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.core.rtti.IRtti;
import org.seasar.kijimuna.core.util.StringUtils;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.KijimunaUI;
import org.seasar.kijimuna.ui.dicon.provider.IExternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.IInternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.walker.ComponentKeyItem;

public class WorkbenchUtils
implements ConstUI {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IStorage getInputResource(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage();
            }
            catch (CoreException e) {
                KijimunaUI.reportException((Exception)((Object)e));
            }
        }
        return null;
    }

    private static IEditorPart openEditor(IStorage storage, String editorID) {
        IWorkbenchPage page;
        if (storage != null && (page = WorkbenchUtils.getWorkbenchPage()) != null) {
            try {
                if (storage instanceof IFile) {
                    if (editorID != null) {
                        FileEditorInput input = new FileEditorInput((IFile)storage);
                        return page.openEditor((IEditorInput)input, editorID);
                    }
                    return IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)storage));
                }
                JarEntryEditorInput input = new JarEntryEditorInput(storage);
                if (editorID != null) {
                    return page.openEditor((IEditorInput)input, editorID);
                }
                return IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, null);
            }
            catch (CoreException e) {
                KijimunaUI.reportException((Exception)((Object)e));
            }
        }
        return null;
    }

    public static IEditorPart openDefaultEditor(IStorage storage) {
        return WorkbenchUtils.openEditor(storage, null);
    }

    public static IEditorPart openDiconEditor(IStorage storage) {
        return WorkbenchUtils.openEditor(storage, "org.seasar.kijimuna.ui.editor.dicon");
    }

    public static IEditorPart openJavaEditor(IRtti rtti) {
        try {
            return EditorUtility.openInEditor((Object)rtti.getType());
        }
        catch (Exception e) {
            KijimunaUI.reportException(e);
            return null;
        }
    }

    public static IEditorPart showSource(IEditorPart part, Object obj) {
        if (obj instanceof ComponentKeyItem) {
            IRtti java;
            ComponentKeyItem componentKeyItem = (ComponentKeyItem)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((java = (IRtti)componentKeyItem.getAdapter(clazz)) != null) {
                return WorkbenchUtils.openJavaEditor(java);
            }
        } else if (obj instanceof IExternalContainer) {
            ContainerElement container = ((IExternalContainer)obj).getExternalContainer();
            if (container != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.resources.IStorage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return WorkbenchUtils.openDiconEditor((IStorage)container.getAdapter((Class)clazz));
            }
        } else if (obj instanceof IInternalContainer) {
            IStorage file;
            Element element = ((IInternalContainer)obj).getElement();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IStorage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IStorage)element.getAdapter((Class)clazz)) != null) {
                IStorage source = null;
                if (part != null) {
                    source = WorkbenchUtils.getInputResource(part);
                }
                if (!file.equals(source)) {
                    int lineNumber = element.getStartLine();
                    IEditorPart editor = WorkbenchUtils.openDiconEditor(file);
                    WorkbenchUtils.moveLine(editor, lineNumber);
                    return editor;
                }
                if (element.getElementName().equals("component") && StringUtils.existValue((String)((ComponentElement)element).getComponentClassName())) {
                    IRtti java;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((java = (IRtti)element.getAdapter((Class)clazz2)) != null) {
                        return WorkbenchUtils.openJavaEditor(java);
                    }
                } else {
                    IRtti rtti;
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.seasar.kijimuna.core.rtti.IRtti");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((rtti = (IRtti)element.getAdapter((Class)clazz3)) != null) {
                        ComponentElement injected;
                        Class<?> clazz4 = class$2;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$2 = Class.forName("org.seasar.kijimuna.core.dicon.model.ComponentElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((injected = (ComponentElement)rtti.getAdapter((Class)clazz4)) != null) {
                            IStorage injectedFile;
                            Class<?> clazz5 = class$1;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$1 = Class.forName("org.eclipse.core.resources.IStorage");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((injectedFile = (IStorage)injected.getAdapter((Class)clazz5)) != null) {
                                IEditorPart editor = !injectedFile.equals(source) ? WorkbenchUtils.openDiconEditor(injectedFile) : part;
                                WorkbenchUtils.moveLine(editor, injected.getStartLine());
                                return editor;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    public static void moveLine(IEditorPart part, int lineNumber) {
        if (part != null && lineNumber > 0) {
            try {
                IStorage file = WorkbenchUtils.getInputResource(part);
                if (file != null && file instanceof IFile) {
                    IMarker marker = ((IFile)file).createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttribute("lineNumber", lineNumber);
                    IDE.gotoMarker((IEditorPart)part, (IMarker)marker);
                    marker.delete();
                }
            }
            catch (CoreException e) {
                KijimunaUI.reportException((Exception)((Object)e));
            }
        }
    }

    public static IWorkbenchPart getWorkbenchPart() {
        IWorkbenchPage page = WorkbenchUtils.getWorkbenchPage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = WorkbenchUtils.getWorkbenchPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static IProject getCurrentProject(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {
                IResource resource;
                Object obj = it.next();
                if (!(obj instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)obj;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) == null) continue;
                return resource.getProject();
            }
        }
        return null;
    }

    public static Object getFirstSelectedElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public static String[] getAllWorkbenchEncodings() {
        String eclipseEnc;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < ConstUI.ECLIPSE_ENCODINGS.length) {
            list.add(ConstUI.ECLIPSE_ENCODINGS[i]);
            ++i;
        }
        String defaultEnc = System.getProperty("file.encoding", "UTF-8");
        if (!list.contains(defaultEnc)) {
            list.add(defaultEnc);
        }
        if (StringUtils.existValue((String)(eclipseEnc = WorkbenchUtils.getWorkbenchEncoding())) && !list.contains(eclipseEnc)) {
            list.add(eclipseEnc);
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public static String getWorkbenchEncoding() {
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        if (StringUtils.noneValue((String)enc)) {
            enc = System.getProperty("file.encoding", "UTF-8");
        }
        return enc;
    }
}

