/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.preference;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.core.util.ProjectUtils;
import org.seasar.kijimuna.ui.KijimunaUI;
import org.seasar.kijimuna.ui.preference.design.ProjectPropertyGUI;
import org.seasar.kijimuna.ui.util.WidgetUtils;

public class ProjectPreferencePage
extends PropertyPage
implements ConstCore {
    private Button natureCheck;
    private TabFolder tabFolder;
    private Combo xmlErrorCombo;
    private Combo xmlWarningCombo;
    private Combo nullInjectionCombo;
    private Combo autoInjectionCombo;
    private Combo javaFetalCombo;
    private Combo diconFetalCombo;
    private Combo diconProblemCombo;

    private IProject getProject() {
        return (IProject)this.getElement();
    }

    protected Control createContents(Composite parent) {
        ProjectPropertyGUI view = new ProjectPropertyGUI(parent, 0);
        this.natureCheck = view.getNatureCheck();
        this.tabFolder = view.getTabFolder();
        this.xmlErrorCombo = view.getXmlErrorCombo();
        this.xmlWarningCombo = view.getXmlWarningCombo();
        this.nullInjectionCombo = view.getNullInjectionCombo();
        this.autoInjectionCombo = view.getAutoInjectionCombo();
        this.javaFetalCombo = view.getJavaFetalCombo();
        this.diconFetalCombo = view.getDiconFetalCombo();
        this.diconProblemCombo = view.getDiconProblemCombo();
        IProject project = this.getProject();
        try {
            boolean flag = project.hasNature("org.seasar.kijimuna.core.nature");
            this.natureCheck.setSelection(flag);
            this.tabFolder.setEnabled(flag);
            this.settingCombos(false);
        }
        catch (CoreException e) {
            KijimunaUI.reportException((Exception)((Object)e));
        }
        return view;
    }

    private void settingCombos(boolean isDefault) {
        IProject project = this.getProject();
        WidgetUtils.setDiconMarkerSettingCombo(project, this.xmlErrorCombo, 0, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(project, this.xmlWarningCombo, 1, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(project, this.nullInjectionCombo, 2, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(project, this.autoInjectionCombo, 3, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(project, this.javaFetalCombo, 4, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(project, this.diconFetalCombo, 5, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(project, this.diconProblemCombo, 6, isDefault);
    }

    public boolean performOk() {
        try {
            if (this.natureCheck.getSelection()) {
                final IProject project = this.getProject();
                boolean alreadyHasNature = ProjectUtils.hasNature((IProject)project, (String)"org.seasar.kijimuna.core.nature");
                if (!alreadyHasNature) {
                    ProjectUtils.addNature((IProject)project, (String)"org.seasar.kijimuna.core.nature");
                }
                MarkerSetting.setDiconMarkerPreference((IProject)project, (int)0, (int)this.xmlErrorCombo.getSelectionIndex());
                MarkerSetting.setDiconMarkerPreference((IProject)project, (int)1, (int)this.xmlWarningCombo.getSelectionIndex());
                MarkerSetting.setDiconMarkerPreference((IProject)project, (int)2, (int)this.nullInjectionCombo.getSelectionIndex());
                MarkerSetting.setDiconMarkerPreference((IProject)project, (int)3, (int)this.autoInjectionCombo.getSelectionIndex());
                MarkerSetting.setDiconMarkerPreference((IProject)project, (int)4, (int)this.javaFetalCombo.getSelectionIndex());
                MarkerSetting.setDiconMarkerPreference((IProject)project, (int)5, (int)this.diconFetalCombo.getSelectionIndex());
                MarkerSetting.setDiconMarkerPreference((IProject)project, (int)6, (int)this.diconProblemCombo.getSelectionIndex());
                if (alreadyHasNature) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    try {
                        window.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Kijimuna.getProjectRecorder().cleanup(project, monitor);
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                ProjectUtils.removeNature((IProject)this.getProject(), (String)"org.seasar.kijimuna.core.nature");
            }
        }
        catch (CoreException e) {
            KijimunaUI.reportException((Exception)((Object)e));
            return false;
        }
        return true;
    }

    protected void performDefaults() {
        if (this.natureCheck.getSelection()) {
            this.settingCombos(true);
        }
    }
}

