/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.preference;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferencePage;
import org.seasar.kijimuna.core.ConstCore;
import org.seasar.kijimuna.core.Kijimuna;
import org.seasar.kijimuna.core.dicon.validation.MarkerSetting;
import org.seasar.kijimuna.ui.preference.design.ProjectPropertyGUI;
import org.seasar.kijimuna.ui.util.WidgetUtils;

public class PluginPreferencePage
extends WorkbenchPreferencePage
implements ConstCore {
    private Combo xmlErrorCombo;
    private Combo xmlWarningCombo;
    private Combo nullInjectionCombo;
    private Combo autoInjectionCombo;
    private Combo javaFetalCombo;
    private Combo diconFetalCombo;
    private Combo diconProblemCombo;

    protected Control createContents(Composite parent) {
        ProjectPropertyGUI view = new ProjectPropertyGUI(parent, 0);
        Button natureCheck = view.getNatureCheck();
        natureCheck.setVisible(false);
        this.xmlErrorCombo = view.getXmlErrorCombo();
        this.xmlWarningCombo = view.getXmlWarningCombo();
        this.nullInjectionCombo = view.getNullInjectionCombo();
        this.autoInjectionCombo = view.getAutoInjectionCombo();
        this.javaFetalCombo = view.getJavaFetalCombo();
        this.diconFetalCombo = view.getDiconFetalCombo();
        this.diconProblemCombo = view.getDiconProblemCombo();
        this.settingCombos(false);
        return view;
    }

    private void settingCombos(boolean isDefault) {
        WidgetUtils.setDiconMarkerSettingCombo(null, this.xmlErrorCombo, 0, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(null, this.xmlWarningCombo, 1, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(null, this.nullInjectionCombo, 2, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(null, this.autoInjectionCombo, 3, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(null, this.javaFetalCombo, 4, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(null, this.diconFetalCombo, 5, isDefault);
        WidgetUtils.setDiconMarkerSettingCombo(null, this.diconProblemCombo, 6, isDefault);
    }

    public boolean performOk() {
        MarkerSetting.setDiconMarkerPreference(null, (int)0, (int)this.xmlErrorCombo.getSelectionIndex());
        MarkerSetting.setDiconMarkerPreference(null, (int)1, (int)this.xmlWarningCombo.getSelectionIndex());
        MarkerSetting.setDiconMarkerPreference(null, (int)2, (int)this.nullInjectionCombo.getSelectionIndex());
        MarkerSetting.setDiconMarkerPreference(null, (int)3, (int)this.autoInjectionCombo.getSelectionIndex());
        MarkerSetting.setDiconMarkerPreference(null, (int)4, (int)this.javaFetalCombo.getSelectionIndex());
        MarkerSetting.setDiconMarkerPreference(null, (int)5, (int)this.diconFetalCombo.getSelectionIndex());
        MarkerSetting.setDiconMarkerPreference(null, (int)6, (int)this.diconProblemCombo.getSelectionIndex());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            window.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Kijimuna.getProjectRecorder().cleanup(monitor);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected void performDefaults() {
        this.settingCombos(true);
    }
}

