/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.dicon.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.seasar.kijimuna.core.util.FileUtils;
import org.seasar.kijimuna.core.util.StringUtils;
import org.seasar.kijimuna.ui.ConstUI;
import org.seasar.kijimuna.ui.KijimunaUI;
import org.seasar.kijimuna.ui.util.WorkbenchUtils;

public class NewDiconWizardPage
extends NewTypeWizardPage
implements ModifyListener,
ConstUI {
    private Text nameText;
    private Combo encodingCombo;

    public NewDiconWizardPage(String pageName) {
        super(false, pageName);
        this.setTitle(KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.1"));
        this.setDescription(KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.2"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, 4);
        this.createPackageControls(composite, 4);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.3"));
        this.nameText = new Text(composite, 2052);
        GridData text1LData1 = new GridData();
        text1LData1.horizontalAlignment = 4;
        text1LData1.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)text1LData1);
        this.nameText.addModifyListener((ModifyListener)this);
        Label nullLabel = new Label(composite, 0);
        GridData nullLabelLData = new GridData();
        nullLabelLData.horizontalSpan = 2;
        nullLabelLData.horizontalAlignment = 4;
        nullLabel.setLayoutData((Object)nullLabelLData);
        Label encodingLabel = new Label(composite, 0);
        encodingLabel.setText(KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.4"));
        this.encodingCombo = new Combo(composite, 0);
        this.initEncodingCombo(this.encodingCombo);
        this.encodingCombo.addModifyListener((ModifyListener)this);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void initEncodingCombo(Combo combo) {
        String setting = WorkbenchUtils.getWorkbenchEncoding();
        combo.setText(setting);
        if (combo.getItemCount() == 0) {
            String[] encodings = WorkbenchUtils.getAllWorkbenchEncodings();
            int i = 0;
            while (i < encodings.length) {
                combo.add(encodings[i]);
                ++i;
            }
        }
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
    }

    private IStatus createStatus(int severity, String message) {
        return new Status(severity, "org.seasar.kijimuna.ui", 0, message, null);
    }

    private IStatus createNameStatus() {
        int severity = 4;
        String message = "";
        if (this.nameText != null) {
            String name = this.nameText.getText();
            if (StringUtils.noneValue((String)name)) {
                message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.5");
            } else {
                severity = 0;
            }
        }
        return this.createStatus(severity, message);
    }

    private IStatus createEncodingStatus() {
        int severity = 4;
        String message = "";
        if (this.encodingCombo != null) {
            String enc = this.encodingCombo.getText();
            if (StringUtils.noneValue((String)enc)) {
                message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.6");
            } else {
                try {
                    String test = "enc test string";
                    test.getBytes(enc);
                    severity = 0;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.7");
                }
            }
        }
        return this.createStatus(severity, message);
    }

    private IStatus createPackageExistStatus() {
        int severity = 4;
        String message = "";
        IPackageFragment pack = this.getPackageFragment();
        if (pack.exists()) {
            severity = 0;
        } else {
            message = KijimunaUI.getResourceString("dicon.wizard.NewDiconWizardPage.8");
        }
        return this.createStatus(severity, message);
    }

    private void doStatusUpdate() {
        IStatus nameStatus = this.createNameStatus();
        IStatus encodingStatus = this.createEncodingStatus();
        IStatus packageExist = this.createPackageExistStatus();
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, nameStatus, encodingStatus, packageExist};
        this.updateStatus(status);
    }

    public void modifyText(ModifyEvent e) {
        this.doStatusUpdate();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameText.setFocus();
        }
    }

    public boolean createDiconFile() {
        IPackageFragment pack = this.getPackageFragment();
        String name = this.nameText.getText();
        if (!name.endsWith(".dicon")) {
            name = String.valueOf(name) + "." + "dicon";
        }
        String enc = this.encodingCombo.getText();
        String dicon = "<?xml version=\"1.0\" encoding=\"" + enc + "\"?>\r\n" + "<!DOCTYPE components PUBLIC \"-//SEASAR//DTD S2Container//EN\"\r\n" + "\t\"http://www.seasar.org/dtd/components.dtd\">\r\n" + "<components>\r\n\r\n\t<component class=\"java.util.ArrayList\">\r\n" + "\t\t\r\n\t</component>\r\n\r\n</components>\r\n";
        try {
            ByteArrayInputStream contents = new ByteArrayInputStream(dicon.getBytes(enc));
            IFile file = FileUtils.createFile((IPackageFragment)pack, (String)name, (InputStream)contents);
            if (file != null) {
                WorkbenchUtils.openDiconEditor((IStorage)file);
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            KijimunaUI.reportException(e);
        }
        return false;
    }
}

