/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.kijimuna.ui.dicon.view;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.seasar.kijimuna.core.parser.Element;
import org.seasar.kijimuna.ui.dicon.provider.DiconContentProvider;
import org.seasar.kijimuna.ui.dicon.provider.DiconLabelProvider;
import org.seasar.kijimuna.ui.dicon.provider.IInternalContainer;
import org.seasar.kijimuna.ui.dicon.provider.walker.ViewContent;
import org.seasar.kijimuna.ui.util.WorkbenchUtils;

public class DiconTreeView
extends ViewPart
implements ISelectionChangedListener,
IPartListener,
IDoubleClickListener {
    private TreeViewer viewer;
    private ISelectionProvider selectionProvider;
    private IWorkbenchPart focusPart;
    private IProject currentProject;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new DiconContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DiconLabelProvider());
        this.viewer.setAutoExpandLevel(1);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.initInput();
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    private void initInput() {
        IEditorPart part = WorkbenchUtils.getActiveEditor();
        if (part == null) {
            part = WorkbenchUtils.getWorkbenchPart();
        }
        this.partActivated((IWorkbenchPart)part);
    }

    private void setInput(IProject project) {
        if (project != null && !project.equals((Object)this.currentProject)) {
            this.currentProject = project;
            this.viewer.setInput((Object)new ViewContent(project));
        }
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void dispose() {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void doubleClick(DoubleClickEvent event) {
        Object obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection());
        WorkbenchUtils.showSource(WorkbenchUtils.getActiveEditor(), obj);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.focusPart == this) {
            Element element;
            Object obj;
            IStorage displayFile;
            IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
            if (editorPart != null && (displayFile = WorkbenchUtils.getInputResource(editorPart)) != null && (obj = WorkbenchUtils.getFirstSelectedElement(event.getSelection())) instanceof IInternalContainer && (element = ((IInternalContainer)obj).getElement()) != null) {
                IStorage selectedFile;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (displayFile.equals(selectedFile = (IStorage)element.getAdapter((Class)clazz))) {
                    WorkbenchUtils.moveLine(editorPart, element.getStartLine());
                }
            }
        } else if (this.selectionProvider != null) {
            this.setInput(WorkbenchUtils.getCurrentProject(this.selectionProvider.getSelection()));
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part != null && part != this.focusPart) {
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionProvider = null;
            }
            if (this.focusPart != part) {
                this.focusPart = part;
                if (this.focusPart != null) {
                    if (this.focusPart instanceof IEditorPart) {
                        IEditorPart editorPart = (IEditorPart)this.focusPart;
                        IStorage storage = WorkbenchUtils.getInputResource(editorPart);
                        if (storage instanceof IFile) {
                            IFile file = (IFile)storage;
                            this.setInput(file.getProject());
                            return;
                        }
                        return;
                    }
                    this.selectionProvider = this.focusPart.getSite().getSelectionProvider();
                    if (this.selectionProvider != null) {
                        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                        this.setInput(WorkbenchUtils.getCurrentProject(this.selectionProvider.getSelection()));
                        return;
                    }
                }
            }
            this.setInput(null);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.focusPart) {
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionProvider = null;
            }
            this.focusPart = null;
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }
}

