package org.seasar.dao;

import org.seasar.extension.jdbc.ColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;

/**
 * @author higa
 *  
 */
public interface BeanMetaData extends DtoMetaData {

	public String TABLE_KEY = "TABLE";

	public String RELNO_KEY_SUFFIX = "_RELNO";

	public String RELKEYS_KEY_SUFFIX = "_RELKEYS";

	public String VERSION_NO_PROPERTY_NAME = "versionNo";

	public String TIMESTAMP_PROPERTY_NAME = "timestamp";

	public String getTableName();

	public PropertyType getVersionNoPropertyType()
			throws PropertyNotFoundRuntimeException;

	public boolean hasVersionNoPropertyType();

	public PropertyType getTimestampPropertyType()
			throws PropertyNotFoundRuntimeException;

	public boolean hasTimestampPropertyType();

	public String convertFullColumnName(String alias);

	public PropertyType getPropertyTypeByAliasName(String aliasName)
			throws ColumnNotFoundRuntimeException;

	public PropertyType getPropertyTypeByColumnName(String columnName)
			throws ColumnNotFoundRuntimeException;

	public boolean hasPropertyTypeByColumnName(String columnName);

	public boolean hasPropertyTypeByAliasName(String aliasName);

	public int getRelationPropertyTypeSize();

	public RelationPropertyType getRelationPropertyType(int index);

	public RelationPropertyType getRelationPropertyType(String propertyName)
			throws PropertyNotFoundRuntimeException;

	public int getPrimaryKeySize();

	public String getPrimaryKey(int index);

	public String getAutoInsertSql();

	public String getAutoUpdateSql();

	public String getAutoDeleteSql();

	public String getAutoSelectList();

	public Object[] getAutoInsertBindVariables(Object bean);

	public Object[] getAutoUpdateBindVariables(Object bean);

	public Object[] getAutoDeleteBindVariables(Object bean);

	public boolean isRelation();
}