package org.seasar.extension.mock.servlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import javax.servlet.ServletOutputStream;

public class MockServletOutputStream extends ServletOutputStream {

	private Writer writer_;

	public MockServletOutputStream() {
		this(new StringWriter());
	}
	
	public MockServletOutputStream(Writer writer) {
		setWriter(writer);
	}

	public Writer getWriter() {
		return writer_;
	}

	public void setWriter(Writer writer) {
		writer_ = writer;
	}

	public void write(int b) throws IOException {
		writer_.write(b);
	}
	
	public String toString() {
		if (writer_ != null) {
			return writer_.toString();
		}
		return super.toString();
	}
}