package org.seasar.tapestry.ognl.binder.impl;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.tapestry.ognl.binder.Binder;

public class GlobalProxy implements Binder {

	private final Object global_;

	public GlobalProxy(Object global) {
		global_ = global;
	}
	public Object get() {
		return global_;
	}
	public Object getBinging(String componentKey) {
		S2Container container = SingletonS2ContainerFactory.getContainer();
		if (container.hasComponentDef(componentKey)) {
			return container.getComponent(componentKey);
		}
		return null ;
	}
}
