/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.PrintWriter;
import java.util.List;
import javassist.Modifier;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;

public class ClassFileWriter {
    public static void print(ClassFile cf) {
        ClassFileWriter.print(cf, new PrintWriter(System.out, true));
    }

    public static void print(ClassFile cf, PrintWriter out) {
        int mod = AccessFlag.toModifier(cf.getAccessFlags() & 0xFFFFFFDF);
        out.println(Modifier.toString(mod) + " class " + cf.getName() + " extends " + cf.getSuperclass());
        out.println();
        ConstPool cp = cf.getConstPool();
        List list = cf.getFields();
        int n = list.size();
        int i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            int acc = finfo.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(acc)) + " " + finfo.getName() + "\t" + finfo.getDescriptor());
            ClassFileWriter.printAttributes(finfo.getAttributes(), out);
            ++i;
        }
        out.println();
        list = cf.getMethods();
        n = list.size();
        int i2 = 0;
        while (i2 < n) {
            MethodInfo minfo = (MethodInfo)list.get(i2);
            int acc = minfo.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(acc)) + " " + minfo.getName() + "\t" + minfo.getDescriptor());
            ClassFileWriter.printAttributes(minfo.getAttributes(), out);
            out.println();
            ++i2;
        }
        out.println();
        ClassFileWriter.printAttributes(cf.getAttributes(), out);
    }

    static void printAttributes(List list, PrintWriter out) {
        if (list == null) {
            return;
        }
        int n = list.size();
        int i = 0;
        while (i < n) {
            AttributeInfo ai = (AttributeInfo)list.get(i);
            if (ai instanceof CodeAttribute) {
                CodeAttribute ca = (CodeAttribute)ai;
                out.println("attribute: " + ai.getName() + ": " + ai.getClass().getName());
                out.println("max stack " + ca.getMaxStack() + ", max locals " + ca.getMaxLocals() + ", " + ca.getExceptionTable().size() + " catch blocks");
                out.println("<code attribute begin>");
                ClassFileWriter.printAttributes(ca.getAttributes(), out);
                out.println("<code attribute end>");
            } else {
                out.println("attribute: " + ai.getName() + " (" + ai.get().length + " byte): " + ai.getClass().getName());
            }
            ++i;
        }
    }
}

