/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.CodeConverter;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtNewWrappedMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.expr.ExprEditor;

public final class CtMethod
extends CtBehavior {
    protected CtMethod next = null;
    protected int cachedHashCode = 0;

    CtMethod(MethodInfo minfo, CtClass declaring) {
        super(declaring, minfo);
    }

    public CtMethod(CtClass returnType, String mname, CtClass[] parameters, CtClass declaring) {
        this(null, declaring);
        ConstPool cp = declaring.getClassFile2().getConstPool();
        String desc = Descriptor.ofMethod(returnType, parameters);
        this.methodInfo = new MethodInfo(cp, mname, desc);
        this.setModifiers(1025);
    }

    public CtMethod(CtMethod src, CtClass declaring, ClassMap map) throws CannotCompileException {
        this(null, declaring);
        MethodInfo srcInfo = src.methodInfo;
        CtClass srcClass = src.getDeclaringClass();
        ConstPool cp = declaring.getClassFile2().getConstPool();
        if (map == null) {
            map = new ClassMap();
        }
        map.put(srcClass.getName(), declaring.getName());
        try {
            String srcSuperName;
            CtClass srcSuper = srcClass.getSuperclass();
            if (srcSuper != null && !(srcSuperName = srcSuper.getName()).equals("java.lang.Object")) {
                map.put(srcSuperName, declaring.getSuperclass().getName());
            }
            this.methodInfo = new MethodInfo(cp, srcInfo.getName(), srcInfo, map);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
    }

    static CtMethod append(CtMethod list, CtMethod tail) {
        tail.next = null;
        if (list == null) {
            return tail;
        }
        CtMethod lst = list;
        while (lst.next != null) {
            lst = lst.next;
        }
        lst.next = tail;
        return list;
    }

    static int count(CtMethod m) {
        int n = 0;
        while (m != null) {
            ++n;
            m = m.next;
        }
        return n;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            String signature = this.methodInfo.getName() + ':' + this.methodInfo.getDescriptor();
            this.cachedHashCode = System.identityHashCode(signature.intern());
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CtMethod && obj.hashCode() == this.hashCode();
    }

    public MethodInfo getMethodInfo() {
        return super.getMethodInfo();
    }

    public int getModifiers() {
        return super.getModifiers();
    }

    public void setModifiers(int mod) {
        super.setModifiers(mod);
    }

    public String getName() {
        return this.methodInfo.getName();
    }

    public void setName(String newname) {
        this.declaringClass.checkModify();
        this.methodInfo.setName(newname);
    }

    public CtClass getDeclaringClass() {
        return super.getDeclaringClass();
    }

    public CtClass[] getParameterTypes() throws NotFoundException {
        return super.getParameterTypes();
    }

    public CtClass getReturnType() throws NotFoundException {
        return this.getReturnType0();
    }

    public String getSignature() {
        return super.getSignature();
    }

    public CtClass[] getExceptionTypes() throws NotFoundException {
        return super.getExceptionTypes();
    }

    public void setExceptionTypes(CtClass[] types) throws NotFoundException {
        super.setExceptionTypes(types);
    }

    public boolean isEmpty() {
        CodeAttribute ca = this.getMethodInfo2().getCodeAttribute();
        if (ca == null) {
            return (this.getModifiers() & 0x400) != 0;
        }
        CodeIterator it = ca.iterator();
        try {
            return it.hasNext() && it.byteAt(it.next()) == 177 && !it.hasNext();
        }
        catch (BadBytecode e) {
            return false;
        }
    }

    public void setBody(String src) throws CannotCompileException {
        super.setBody(src);
    }

    public void setBody(CtMethod src, ClassMap map) throws CannotCompileException {
        CtBehavior.setBody0(src.declaringClass, src.methodInfo, this.declaringClass, this.methodInfo, map);
    }

    public void setWrappedBody(CtMethod mbody, ConstParameter constParam) throws CannotCompileException {
        CtClass retType;
        CtClass[] params;
        this.declaringClass.checkModify();
        CtClass clazz = this.getDeclaringClass();
        try {
            params = this.getParameterTypes();
            retType = this.getReturnType();
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        Bytecode code = CtNewWrappedMethod.makeBody(clazz, clazz.getClassFile2(), mbody, params, retType, constParam);
        CodeAttribute cattr = code.toCodeAttribute();
        this.methodInfo.setCodeAttribute(cattr);
        this.methodInfo.setAccessFlags(this.methodInfo.getAccessFlags() & 0xFFFFFBFF);
    }

    public byte[] getAttribute(String name) {
        return super.getAttribute(name);
    }

    public void setAttribute(String name, byte[] data) {
        super.setAttribute(name, data);
    }

    public void useCflow(String name) throws CannotCompileException {
        super.useCflow(name);
    }

    public void instrument(CodeConverter converter) throws CannotCompileException {
        super.instrument(converter);
    }

    public void instrument(ExprEditor editor) throws CannotCompileException {
        super.instrument(editor);
    }

    public void insertBefore(String src) throws CannotCompileException {
        super.insertBefore(src);
    }

    public void insertAfter(String src) throws CannotCompileException {
        super.insertAfter(src);
    }

    public void insertAfter(String src, boolean asFinally) throws CannotCompileException {
        super.insertAfter(src, asFinally);
    }

    public void addCatch(String src, CtClass exceptionType) throws CannotCompileException {
        super.addCatch(src, exceptionType);
    }

    static class StringConstParameter
    extends ConstParameter {
        String param;

        StringConstParameter(String s) {
            this.param = s;
        }

        int compile(Bytecode code) throws CannotCompileException {
            code.addLdc(this.param);
            return 1;
        }

        String descriptor() {
            return "([Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;";
        }

        String constDescriptor() {
            return "([Ljava/lang/Object;Ljava/lang/String;)V";
        }
    }

    static class LongConstParameter
    extends ConstParameter {
        long param;

        LongConstParameter(long l) {
            this.param = l;
        }

        int compile(Bytecode code) throws CannotCompileException {
            code.addLconst(this.param);
            return 2;
        }

        String descriptor() {
            return "([Ljava/lang/Object;J)Ljava/lang/Object;";
        }

        String constDescriptor() {
            return "([Ljava/lang/Object;J)V";
        }
    }

    static class IntConstParameter
    extends ConstParameter {
        int param;

        IntConstParameter(int i) {
            this.param = i;
        }

        int compile(Bytecode code) throws CannotCompileException {
            code.addIconst(this.param);
            return 1;
        }

        String descriptor() {
            return "([Ljava/lang/Object;I)Ljava/lang/Object;";
        }

        String constDescriptor() {
            return "([Ljava/lang/Object;I)V";
        }
    }

    public static class ConstParameter {
        public static ConstParameter integer(int i) {
            return new IntConstParameter(i);
        }

        public static ConstParameter integer(long i) {
            return new LongConstParameter(i);
        }

        public static ConstParameter string(String s) {
            return new StringConstParameter(s);
        }

        ConstParameter() {
        }

        int compile(Bytecode code) throws CannotCompileException {
            return 0;
        }

        String descriptor() {
            return ConstParameter.defaultDescriptor();
        }

        static String defaultDescriptor() {
            return "([Ljava/lang/Object;)Ljava/lang/Object;";
        }

        String constDescriptor() {
            return ConstParameter.defaultConstDescriptor();
        }

        static String defaultConstDescriptor() {
            return "([Ljava/lang/Object;)V";
        }
    }
}

