/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.record.ChangeKey;
import org.apache.tapestry.record.PageChange;
import org.apache.tapestry.record.PageRecorder;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.util.StringSplitter;

public class SessionPageRecorder
extends PageRecorder {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$record$SessionPageRecorder == null ? (class$org$apache$tapestry$record$SessionPageRecorder = SessionPageRecorder.class$("org.apache.tapestry.record.SessionPageRecorder")) : class$org$apache$tapestry$record$SessionPageRecorder));
    private Map _changes;
    private HttpSession _session;
    private String _pageName;
    private String _attributePrefix;
    static /* synthetic */ Class class$org$apache$tapestry$record$SessionPageRecorder;

    public void initialize(String pageName, IRequestCycle cycle) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initializing for " + pageName));
        }
        RequestContext context = cycle.getRequestContext();
        this._pageName = pageName;
        this._session = context.getSession();
        this._attributePrefix = context.getServlet().getServletName() + "/" + this._pageName + "/";
        this.restorePageChanges();
    }

    public void discard() {
        if (Tapestry.isEmpty(this._changes)) {
            return;
        }
        Iterator i = this._changes.keySet().iterator();
        while (i.hasNext()) {
            ChangeKey key = (ChangeKey)i.next();
            String attributeKey = this.constructAttributeKey(key.getComponentPath(), key.getPropertyName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing session attribute " + attributeKey));
            }
            this._session.removeAttribute(attributeKey);
        }
    }

    public void commit() {
        this.setDirty(false);
        this.setLocked(true);
    }

    public boolean getHasChanges() {
        if (this._changes == null) {
            return false;
        }
        return this._changes.size() > 0;
    }

    public Collection getChanges() {
        if (this._changes == null) {
            return Collections.EMPTY_LIST;
        }
        int count = this._changes.size();
        ArrayList<PageChange> result = new ArrayList<PageChange>(count);
        Iterator i = this._changes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ChangeKey key = (ChangeKey)entry.getKey();
            Object value = entry.getValue();
            PageChange change = new PageChange(key.getComponentPath(), key.getPropertyName(), value);
            result.add(change);
        }
        return result;
    }

    protected void recordChange(String componentPath, String propertyName, Object newValue) {
        ChangeKey key = new ChangeKey(componentPath, propertyName);
        if (this._changes == null) {
            this._changes = new HashMap();
        }
        this.setDirty(true);
        this._changes.put(key, newValue);
        String attributeKey = this.constructAttributeKey(componentPath, propertyName);
        this._session.setAttribute(attributeKey, newValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stored session attribute " + attributeKey + " = " + newValue));
        }
    }

    private String constructAttributeKey(String componentPath, String propertyName) {
        StringBuffer buffer = new StringBuffer(this._attributePrefix);
        if (componentPath != null) {
            buffer.append(componentPath);
            buffer.append('/');
        }
        buffer.append(propertyName);
        return buffer.toString();
    }

    private void restorePageChanges() {
        int count = 0;
        Enumeration e = this._session.getAttributeNames();
        StringSplitter splitter = null;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(this._attributePrefix)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Restoring page change from session attribute " + key));
            }
            if (this._changes == null) {
                this._changes = new HashMap();
                splitter = new StringSplitter('/');
            }
            String[] names = splitter.splitToArray(key);
            int i = 2;
            String componentPath = names.length == 4 ? names[i++] : null;
            String propertyName = names[i++];
            Object value = this._session.getAttribute(key);
            ChangeKey changeKey = new ChangeKey(componentPath, propertyName);
            this._changes.put(changeKey, value);
            ++count;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(count == 0 ? "No recorded changes." : "Restored " + count + " recorded changes."));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

