/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TokenType;

public class TextToken
extends TemplateToken
implements IRender {
    private char[] _templateData;
    private int _startIndex = -1;
    private int _endIndex = -1;
    private int _offset;
    private int _length;
    private boolean _needsTrim = true;

    public TextToken(char[] templateData, int startIndex, int endIndex, ILocation location) {
        super(TokenType.TEXT, location);
        if (startIndex < 0 || endIndex < 0 || startIndex > templateData.length || endIndex > templateData.length) {
            throw new IllegalArgumentException(Tapestry.format("TextToken.range-error", this, Integer.toString(templateData.length)));
        }
        this._templateData = templateData;
        this._startIndex = startIndex;
        this._endIndex = endIndex;
        this._offset = startIndex;
        this._length = endIndex - startIndex + 1;
    }

    public synchronized void render(IMarkupWriter writer, IRequestCycle cycle) {
        if (this._needsTrim) {
            this.trim();
            this._needsTrim = false;
        }
        if (this._length == 0) {
            return;
        }
        writer.printRaw(this._templateData, this._offset, this._length);
    }

    private void trim() {
        if (this._length == 0) {
            return;
        }
        try {
            char ch;
            boolean didTrim = false;
            while (this._length > 0) {
                ch = this._templateData[this._offset + this._length - 1];
                if (!Character.isWhitespace(ch)) break;
                --this._length;
                didTrim = true;
            }
            if (didTrim) {
                ++this._length;
            }
            didTrim = false;
            while (this._length > 0) {
                ch = this._templateData[this._offset];
                if (!Character.isWhitespace(ch)) break;
                ++this._offset;
                --this._length;
                didTrim = true;
            }
            if (didTrim) {
                --this._offset;
                ++this._length;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RuntimeException(Tapestry.format("TextToken.error-trimming", this));
        }
    }

    protected void extendDescription(ToStringBuilder builder) {
        builder.append("startIndex", this._startIndex);
        builder.append("endIndex", this._endIndex);
    }

    public int getEndIndex() {
        return this._endIndex;
    }

    public int getStartIndex() {
        return this._startIndex;
    }

    public char[] getTemplateData() {
        return this._templateData;
    }
}

