/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String EMPTY_ARGS_NAME = "CGLIB$emptyArgs";
    static final String FIND_PROXY_NAME = "CGLIB$findMethodProxy";
    static final Class[] FIND_PROXY_TYPES = new Class[]{class$net$sf$cglib$core$Signature == null ? (class$net$sf$cglib$core$Signature = MethodInterceptorGenerator.class$("net.sf.cglib.core.Signature")) : class$net$sf$cglib$core$Signature};
    private static final Signature FIND_PROXY = new Signature("CGLIB$findMethodProxy", TypeUtils.parseType("net.sf.cglib.proxy.MethodProxy"), TypeUtils.getTypes(FIND_PROXY_TYPES));
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType("AbstractMethodError");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Type METHOD_PROXY = TypeUtils.parseType("net.sf.cglib.proxy.MethodProxy");
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType("net.sf.cglib.proxy.MethodInterceptor");
    private static final Signature GET_DECLARING_CLASS = TypeUtils.parseSignature("Class getDeclaringClass()");
    private static final Signature GET_CLASS_LOADER = TypeUtils.parseSignature("ClassLoader getClassLoader()");
    private static final Signature MAKE_PROXY = TypeUtils.parseSignature("net.sf.cglib.proxy.MethodProxy create(ClassLoader, Class, Class, String, String, String)");
    private static final Signature INTERCEPT = TypeUtils.parseSignature("Object intercept(Object, java.lang.reflect.Method, Object[], net.sf.cglib.proxy.MethodProxy)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    static /* synthetic */ Class class$net$sf$cglib$core$Signature;

    MethodInterceptorGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context) {
        HashMap<String, String> sigMap = new HashMap<String, String>();
        Iterator it = context.getMethods();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            String accessName = this.getAccessName(context, method);
            String fieldName = this.getFieldName(context, method);
            sigMap.put(ReflectUtils.getSignature(method).toString(), accessName);
            ce.declare_field(26, fieldName, METHOD, null, null);
            ce.declare_field(26, accessName, METHOD_PROXY, null, null);
            ce.declare_field(26, EMPTY_ARGS_NAME, Constants.TYPE_OBJECT_ARRAY, null, null);
            CodeEmitter e = ce.begin_method(16, new Signature(this.getAccessName(context, method), ReflectUtils.getSignature(method).getDescriptor()), ReflectUtils.getExceptionTypes(method), null);
            if (Modifier.isAbstract(method.getModifiers())) {
                e.throw_exception(ABSTRACT_METHOD_ERROR, method.toString() + " is abstract");
            } else {
                e.load_this();
                e.load_args();
                e.super_invoke(ReflectUtils.getSignature(method));
            }
            e.return_value();
            e.end_method();
            e = ce.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            Label nullInterceptor = e.make_label();
            context.emitCallback(e, context.getIndex(method));
            e.dup();
            e.ifnull(nullInterceptor);
            e.load_this();
            e.getfield(fieldName);
            if (method.getParameterTypes().length == 0) {
                e.getfield(EMPTY_ARGS_NAME);
            } else {
                e.create_arg_array();
            }
            e.getfield(accessName);
            e.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            e.unbox_or_zero(Type.getType(method.getReturnType()));
            e.return_value();
            e.mark(nullInterceptor);
            e.load_this();
            e.load_args();
            e.super_invoke(ReflectUtils.getSignature(method));
            e.return_value();
            e.end_method();
        }
        this.generateFindProxy(ce, sigMap);
    }

    private String getFieldName(CallbackGenerator.Context context, Method method) {
        return "CGLIB$$METHOD_" + context.getUniqueName(method);
    }

    private String getAccessName(CallbackGenerator.Context context, Method method) {
        return "CGLIB$$ACCESS_" + context.getUniqueName(method);
    }

    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context) {
        Local thisclass = e.make_local();
        EmitUtils.load_class_this(e);
        e.dup();
        e.store_local(thisclass);
        e.invoke_virtual(Constants.TYPE_CLASS, GET_CLASS_LOADER);
        e.push(0);
        e.newarray();
        e.putfield(EMPTY_ARGS_NAME);
        Iterator it = context.getMethods();
        while (it.hasNext()) {
            e.dup();
            Method method = (Method)it.next();
            EmitUtils.load_method(e, method);
            e.dup();
            e.putfield(this.getFieldName(context, method));
            String accessName = this.getAccessName(context, method);
            Signature sig = ReflectUtils.getSignature(method);
            e.invoke_virtual(METHOD, GET_DECLARING_CLASS);
            e.load_local(thisclass);
            e.push(sig.getDescriptor());
            e.push(sig.getName());
            e.push(accessName);
            e.invoke_static(METHOD_PROXY, MAKE_PROXY);
            e.putfield(accessName);
        }
    }

    public void generateFindProxy(ClassEmitter ce, final Map sigMap) {
        final CodeEmitter e = ce.begin_method(9, FIND_PROXY, null, null);
        e.load_arg(0);
        e.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                e.getfield((String)sigMap.get(key));
                e.return_value();
            }

            public void processDefault() {
                e.aconst_null();
                e.return_value();
            }
        };
        EmitUtils.string_switch(e, sigMap.keySet().toArray(new String[0]), 1, callback);
        e.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

