/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtBehavior;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.expr.ExprEditor;

public abstract class CtClass {
    protected String qualifiedName;
    public static final String version = "2.6";
    static final String javaLangObject = "java.lang.Object";
    public static CtClass booleanType;
    public static CtClass charType;
    public static CtClass byteType;
    public static CtClass shortType;
    public static CtClass intType;
    public static CtClass longType;
    public static CtClass floatType;
    public static CtClass doubleType;
    public static CtClass voidType;
    static CtClass[] primitiveTypes;

    protected CtClass(String name) {
        this.qualifiedName = name;
    }

    public ClassPool getClassPool() {
        return null;
    }

    public ClassFile getClassFile() {
        this.checkModify();
        return this.getClassFile2();
    }

    public ClassFile getClassFile2() {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isFrozen() {
        return true;
    }

    void freeze() {
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            throw new RuntimeException("the class is frozen");
        }
    }

    public void defrost() {
        throw new RuntimeException("cannot defrost " + this.getName());
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public CtClass getComponentType() throws NotFoundException {
        return null;
    }

    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        return this == clazz || this.getName().equals(clazz.getName());
    }

    public String getName() {
        return this.qualifiedName;
    }

    public final String getSimpleName() {
        String qname = this.qualifiedName;
        int index = qname.lastIndexOf(46);
        if (index < 0) {
            return qname;
        }
        return qname.substring(index + 1);
    }

    public final String getPackageName() {
        String qname = this.qualifiedName;
        int index = qname.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return qname.substring(0, index);
    }

    public void setName(String name) {
        this.checkModify();
        if (name != null) {
            this.qualifiedName = name;
        }
    }

    public void replaceClassName(String oldname, String newname) {
        this.checkModify();
    }

    public void replaceClassName(ClassMap map) {
        this.checkModify();
    }

    public Collection getRefClasses() {
        ClassFile cf = this.getClassFile2();
        if (cf != null) {
            ClassMap cm = new ClassMap(){

                public void put(String oldname, String newname) {
                    this.put0(oldname, newname);
                }

                public Object get(Object jvmClassName) {
                    String n = ClassMap.toJavaName((String)jvmClassName);
                    this.put0(n, n);
                    return null;
                }

                public void fix(String name) {
                }
            };
            cf.renameClass(cm);
            return cm.values();
        }
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    public int getModifiers() {
        return 0;
    }

    public void setModifiers(int mod) {
        this.checkModify();
    }

    public boolean subclassOf(CtClass superclass) {
        return false;
    }

    public CtClass getSuperclass() throws NotFoundException {
        return null;
    }

    public void setSuperclass(CtClass clazz) throws CannotCompileException {
        this.checkModify();
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        return new CtClass[0];
    }

    public void setInterfaces(CtClass[] list) {
        this.checkModify();
    }

    public void addInterface(CtClass anInterface) {
        this.checkModify();
    }

    public CtField[] getFields() {
        return new CtField[0];
    }

    public CtField getField(String name) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public CtField[] getDeclaredFields() {
        return new CtField[0];
    }

    public CtField getDeclaredField(String name) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public CtBehavior[] getDeclaredBehaviors() {
        return new CtBehavior[0];
    }

    public CtConstructor[] getConstructors() {
        return new CtConstructor[0];
    }

    public CtConstructor getConstructor(String desc) throws NotFoundException {
        throw new NotFoundException("no such a constructor");
    }

    public CtConstructor[] getDeclaredConstructors() {
        return new CtConstructor[0];
    }

    public CtConstructor getDeclaredConstructor(CtClass[] params) throws NotFoundException {
        String desc = Descriptor.ofConstructor(params);
        return this.getConstructor(desc);
    }

    public CtConstructor getClassInitializer() {
        return null;
    }

    public CtMethod[] getMethods() {
        return new CtMethod[0];
    }

    public CtMethod getMethod(String name, String desc) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public CtMethod[] getDeclaredMethods() {
        return new CtMethod[0];
    }

    public CtMethod getDeclaredMethod(String name, CtClass[] params) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public CtMethod getDeclaredMethod(String name) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public CtConstructor makeClassInitializer() throws CannotCompileException {
        throw new CannotCompileException("not a class");
    }

    public void addConstructor(CtConstructor c) throws CannotCompileException {
        this.checkModify();
    }

    public void addMethod(CtMethod m) throws CannotCompileException {
        this.checkModify();
    }

    public void addField(CtField f) throws CannotCompileException {
        this.addField(f, (CtField.Initializer)null);
    }

    public void addField(CtField f, String init) throws CannotCompileException {
        this.checkModify();
    }

    public void addField(CtField f, CtField.Initializer init) throws CannotCompileException {
        this.checkModify();
    }

    public byte[] getAttribute(String name) {
        return null;
    }

    public void setAttribute(String name, byte[] data) {
        this.checkModify();
    }

    public void instrument(CodeConverter converter) throws CannotCompileException {
        this.checkModify();
    }

    public void instrument(ExprEditor editor) throws CannotCompileException {
        this.checkModify();
    }

    public Class toClass() throws NotFoundException, IOException, CannotCompileException {
        return this.getClassPool2().writeAsClass(this.getName());
    }

    public byte[] toBytecode() throws NotFoundException, IOException, CannotCompileException {
        return this.getClassPool2().write(this.getName());
    }

    public void writeFile() throws NotFoundException, IOException, CannotCompileException {
        this.getClassPool2().writeFile(this.getName());
    }

    private ClassPool getClassPool2() throws CannotCompileException {
        ClassPool cp = this.getClassPool();
        if (cp == null) {
            throw new CannotCompileException("no ClassPool found. not a class?");
        }
        return cp;
    }

    void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        throw new CannotCompileException("not a class");
    }

    static {
        primitiveTypes = new CtClass[9];
        CtClass.primitiveTypes[0] = booleanType = new CtPrimitiveType("boolean", 'Z', "java.lang.Boolean", "booleanValue", "()Z", 172, 4, 1);
        CtClass.primitiveTypes[1] = charType = new CtPrimitiveType("char", 'C', "java.lang.Character", "charValue", "()C", 172, 5, 1);
        CtClass.primitiveTypes[2] = byteType = new CtPrimitiveType("byte", 'B', "java.lang.Byte", "byteValue", "()B", 172, 8, 1);
        CtClass.primitiveTypes[3] = shortType = new CtPrimitiveType("short", 'S', "java.lang.Short", "shortValue", "()S", 172, 9, 1);
        CtClass.primitiveTypes[4] = intType = new CtPrimitiveType("int", 'I', "java.lang.Integer", "intValue", "()I", 172, 10, 1);
        CtClass.primitiveTypes[5] = longType = new CtPrimitiveType("long", 'J', "java.lang.Long", "longValue", "()J", 173, 11, 2);
        CtClass.primitiveTypes[6] = floatType = new CtPrimitiveType("float", 'F', "java.lang.Float", "floatValue", "()F", 174, 6, 1);
        CtClass.primitiveTypes[7] = doubleType = new CtPrimitiveType("double", 'D', "java.lang.Double", "doubleValue", "()D", 175, 7, 2);
        CtClass.primitiveTypes[8] = voidType = new CtPrimitiveType("void", 'V', "java.lang.Void", null, null, 177, 0, 0);
    }
}

