/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsi.scm.retailer;

import javax.xml.rpc.ServiceException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.axis.wsi.scm.configuration.ConfigurationFaultType;
import org.apache.axis.wsi.scm.configuration.ConfigurationType;
import org.apache.axis.wsi.scm.retailer.BadOrderFault;
import org.apache.axis.wsi.scm.retailer.RetailerServiceLocator;
import org.apache.axis.wsi.scm.retailer.RetailerSoapBindingStub;
import org.apache.axis.wsi.scm.retailer.catalog.CatalogItem;
import org.apache.axis.wsi.scm.retailer.catalog.CatalogType;
import org.apache.axis.wsi.scm.retailer.order.CustomerDetailsType;
import org.apache.axis.wsi.scm.retailer.order.InvalidProductCodeType;
import org.apache.axis.wsi.scm.retailer.order.PartsOrderResponseType;
import org.apache.axis.wsi.scm.retailer.order.PartsOrderType;

public class RetailerServiceTestCase
extends TestCase {
    public RetailerServiceTestCase(String name) {
        super(name);
    }

    public void test1RetailerPortGetCatalog() throws Exception {
        RetailerSoapBindingStub binding;
        try {
            binding = (RetailerSoapBindingStub)new RetailerServiceLocator().getRetailerPort();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        RetailerServiceTestCase.assertNotNull((String)"binding is null", (Object)binding);
        binding.setTimeout(60000);
        CatalogType catalog = null;
        catalog = binding.getCatalog();
        RetailerServiceTestCase.assertNotNull((String)"catalog is null", (Object)catalog);
        CatalogItem[] items = catalog.getItem();
        RetailerServiceTestCase.assertTrue((items.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < items.length; ++i) {
            System.out.println("------------------");
            System.out.println(items[i].getName());
            System.out.println(items[i].getBrand());
        }
    }

    public void test2RetailerPortSubmitOrder() throws Exception {
        RetailerSoapBindingStub binding;
        try {
            binding = (RetailerSoapBindingStub)new RetailerServiceLocator().getRetailerPort();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        RetailerServiceTestCase.assertNotNull((String)"binding is null", (Object)binding);
        binding.setTimeout(60000);
        try {
            PartsOrderResponseType value = null;
            value = binding.submitOrder(new PartsOrderType(), new CustomerDetailsType(), new ConfigurationType());
        }
        catch (InvalidProductCodeType e1) {
            throw new AssertionFailedError("InvalidProductCode Exception caught: " + e1);
        }
        catch (BadOrderFault e2) {
            throw new AssertionFailedError("BadOrder Exception caught: " + e2);
        }
        catch (ConfigurationFaultType e3) {
            throw new AssertionFailedError("ConfigurationFault Exception caught: " + e3);
        }
    }
}

